/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.util.StringTokenizer;

class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String[] split(String text, String separator) {
        return StringUtils.split(text, separator, -1);
    }

    private static String[] split(String str, String separator, int max) {
        StringTokenizer tok = separator == null ? new StringTokenizer(str) : new StringTokenizer(str, separator);
        int listSize = tok.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i2 = 0;
        int lastTokenEnd = 0;
        while (tok.hasMoreTokens()) {
            int lastTokenBegin;
            if (max > 0 && i2 == listSize - 1) {
                String endToken = tok.nextToken();
                lastTokenBegin = str.indexOf(endToken, lastTokenEnd);
                list[i2] = str.substring(lastTokenBegin);
                break;
            }
            list[i2] = tok.nextToken();
            lastTokenBegin = str.indexOf(list[i2], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list[i2].length();
            ++i2;
        }
        return list;
    }

    public static String repeat(String str, int repeat) {
        StringBuilder buffer = new StringBuilder(repeat * str.length());
        for (int i2 = 0; i2 < repeat; ++i2) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static String removeDuplicateWhitespace(String s) {
        StringBuilder result = new StringBuilder();
        int length = s.length();
        boolean isPreviousWhiteSpace = false;
        for (int i2 = 0; i2 < length; ++i2) {
            char c = s.charAt(i2);
            boolean thisCharWhiteSpace = Character.isWhitespace(c);
            if (!isPreviousWhiteSpace || !thisCharWhiteSpace) {
                result.append(c);
            }
            isPreviousWhiteSpace = thisCharWhiteSpace;
        }
        return result.toString();
    }

    public static String unifyLineSeparators(String s, String ls) {
        if (s == null) {
            return null;
        }
        if (ls == null) {
            ls = System.getProperty("line.separator");
        }
        if (!(ls.equals("\n") || ls.equals("\r") || ls.equals("\r\n"))) {
            throw new IllegalArgumentException("Requested line separator is invalid.");
        }
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            if (s.charAt(i2) == '\r') {
                if (i2 + 1 < length && s.charAt(i2 + 1) == '\n') {
                    ++i2;
                }
                buffer.append(ls);
                continue;
            }
            if (s.charAt(i2) == '\n') {
                buffer.append(ls);
                continue;
            }
            buffer.append(s.charAt(i2));
        }
        return buffer.toString();
    }
}

