/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.PreCompCallback;
import org.bouncycastle.math.ec.PreCompInfo;

public class FixedPointUtil {
    public static final String PRECOMP_NAME = "bc_fixed_point";

    public static int getCombSize(ECCurve eCCurve) {
        BigInteger bigInteger = eCCurve.getOrder();
        return bigInteger == null ? eCCurve.getFieldSize() + 1 : bigInteger.bitLength();
    }

    public static FixedPointPreCompInfo getFixedPointPreCompInfo(PreCompInfo preCompInfo) {
        return preCompInfo instanceof FixedPointPreCompInfo ? (FixedPointPreCompInfo)preCompInfo : null;
    }

    public static FixedPointPreCompInfo precompute(final ECPoint eCPoint) {
        final ECCurve eCCurve = eCPoint.getCurve();
        return (FixedPointPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, new PreCompCallback(){

            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                int n;
                int n2;
                int n3;
                FixedPointPreCompInfo fixedPointPreCompInfo = preCompInfo instanceof FixedPointPreCompInfo ? (FixedPointPreCompInfo)preCompInfo : null;
                if (this.checkExisting(fixedPointPreCompInfo, n3 = 1 << (n2 = (n = FixedPointUtil.getCombSize(eCCurve)) > 250 ? 6 : 5))) {
                    return fixedPointPreCompInfo;
                }
                int n4 = (n + n2 - 1) / n2;
                ECPoint[] eCPointArray = new ECPoint[n2 + 1];
                eCPointArray[0] = eCPoint;
                for (int j = 1; j < n2; ++j) {
                    eCPointArray[j] = eCPointArray[j - 1].timesPow2(n4);
                }
                eCPointArray[n2] = eCPointArray[0].subtract(eCPointArray[1]);
                eCCurve.normalizeAll(eCPointArray);
                ECPoint[] eCPointArray2 = new ECPoint[n3];
                eCPointArray2[0] = eCPointArray[0];
                for (int j = n2 - 1; j >= 0; --j) {
                    int n5;
                    ECPoint eCPoint2 = eCPointArray[j];
                    for (int k = n5 = 1 << j; k < n3; k += n5 << 1) {
                        eCPointArray2[k] = eCPointArray2[k - n5].add(eCPoint2);
                    }
                }
                eCCurve.normalizeAll(eCPointArray2);
                FixedPointPreCompInfo fixedPointPreCompInfo2 = new FixedPointPreCompInfo();
                fixedPointPreCompInfo2.setLookupTable(eCCurve.createCacheSafeLookupTable(eCPointArray2, 0, eCPointArray2.length));
                fixedPointPreCompInfo2.setOffset(eCPointArray[n2]);
                fixedPointPreCompInfo2.setWidth(n2);
                return fixedPointPreCompInfo2;
            }

            private boolean checkExisting(FixedPointPreCompInfo fixedPointPreCompInfo, int n) {
                return fixedPointPreCompInfo != null && this.checkTable(fixedPointPreCompInfo.getLookupTable(), n);
            }

            private boolean checkTable(ECLookupTable eCLookupTable, int n) {
                return eCLookupTable != null && eCLookupTable.getSize() >= n;
            }
        });
    }
}

