/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import java.util.Iterator;
import org.apache.velocity.tools.config.Configuration;
import org.apache.velocity.tools.config.ConfigurationException;
import org.apache.velocity.tools.config.Data;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.config.Property;
import org.apache.velocity.tools.config.ToolConfiguration;
import org.apache.velocity.tools.config.ToolboxConfiguration;
import org.slf4j.Logger;

public class ConfigurationCleaner {
    private Logger LOG = null;

    public void setLog(Logger log) {
        if (log == null) {
            throw new NullPointerException("log should not be set to null");
        }
        this.LOG = log;
    }

    public void clean(FactoryConfiguration factory) {
        if (this.LOG != null) {
            this.LOG.trace("ConfigurationCleaner : Cleaning factory: {}", (Object)factory);
        }
        this.cleanProperties(factory);
        Iterator i2 = factory.getData().iterator();
        while (i2.hasNext()) {
            Data datum = (Data)i2.next();
            try {
                datum.validate();
            }
            catch (ConfigurationException ce) {
                if (this.LOG != null) {
                    this.LOG.debug("ConfigurationCleaner : ", ce);
                    this.LOG.warn("ConfigurationCleaner : Removing {}", (Object)datum);
                }
                i2.remove();
            }
        }
        for (ToolboxConfiguration toolbox : factory.getToolboxes()) {
            this.clean(toolbox);
        }
    }

    public void clean(ToolboxConfiguration toolbox) {
        this.cleanProperties(toolbox);
        Iterator<ToolConfiguration> i2 = toolbox.getTools().iterator();
        while (i2.hasNext()) {
            ToolConfiguration tool = i2.next();
            this.cleanProperties(tool);
            try {
                tool.validate();
            }
            catch (ConfigurationException ce) {
                if (this.LOG != null) {
                    this.LOG.debug("ConfigurationCleaner : ", ce);
                    this.LOG.warn("ConfigurationCleaner : Removing {}", (Object)tool);
                }
                i2.remove();
            }
        }
    }

    public void clean(Configuration config) {
        if (config instanceof FactoryConfiguration) {
            this.clean((FactoryConfiguration)config);
        } else if (config instanceof ToolboxConfiguration) {
            this.clean((ToolboxConfiguration)config);
        } else {
            this.cleanProperties(config);
        }
    }

    public void cleanProperties(Configuration config) {
        Iterator i2 = config.getProperties().iterator();
        while (i2.hasNext()) {
            Property prop = (Property)i2.next();
            try {
                prop.validate();
            }
            catch (ConfigurationException ce) {
                if (this.LOG != null) {
                    this.LOG.debug("ConfigurationCleaner : ", ce);
                    this.LOG.warn("ConfigurationCleaner : Removing {}", (Object)prop);
                }
                i2.remove();
            }
        }
    }
}

