/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.traversal;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class SerializingDependencyNodeVisitor
implements DependencyNodeVisitor {
    public static final GraphTokens WHITESPACE_TOKENS = new GraphTokens("   ", "   ", "   ", "   ");
    public static final GraphTokens STANDARD_TOKENS = new GraphTokens("+- ", "\\- ", "|  ", "   ");
    public static final GraphTokens EXTENDED_TOKENS = new GraphTokens("\u251c\u2500 ", "\u2514\u2500 ", "\u2502  ", "   ");
    private final PrintWriter writer;
    private final GraphTokens tokens;
    private int depth;

    public SerializingDependencyNodeVisitor(Writer writer) {
        this(writer, WHITESPACE_TOKENS);
    }

    public SerializingDependencyNodeVisitor(Writer writer, GraphTokens tokens) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
        this.tokens = tokens;
        this.depth = 0;
    }

    @Override
    public boolean visit(DependencyNode node) {
        this.indent(node);
        this.writer.println(node.toNodeString());
        ++this.depth;
        return true;
    }

    @Override
    public boolean endVisit(DependencyNode node) {
        --this.depth;
        return true;
    }

    private void indent(DependencyNode node) {
        for (int i2 = 1; i2 < this.depth; ++i2) {
            this.writer.write(this.tokens.getFillIndent(this.isLast(node, i2)));
        }
        if (this.depth > 0) {
            this.writer.write(this.tokens.getNodeIndent(this.isLast(node)));
        }
    }

    private boolean isLast(DependencyNode node) {
        List<DependencyNode> siblings;
        DependencyNode parent = node.getParent();
        boolean last = parent == null ? true : (siblings = parent.getChildren()).indexOf(node) == siblings.size() - 1;
        return last;
    }

    private boolean isLast(DependencyNode node, int ancestorDepth) {
        int distance = this.depth - ancestorDepth;
        while (distance-- > 0) {
            node = node.getParent();
        }
        return this.isLast(node);
    }

    public static class GraphTokens {
        private final String nodeIndent;
        private final String lastNodeIndent;
        private final String fillIndent;
        private final String lastFillIndent;

        public GraphTokens(String nodeIndent, String lastNodeIndent, String fillIndent, String lastFillIndent) {
            this.nodeIndent = nodeIndent;
            this.lastNodeIndent = lastNodeIndent;
            this.fillIndent = fillIndent;
            this.lastFillIndent = lastFillIndent;
        }

        public String getNodeIndent(boolean last) {
            return last ? this.lastNodeIndent : this.nodeIndent;
        }

        public String getFillIndent(boolean last) {
            return last ? this.lastFillIndent : this.fillIndent;
        }
    }
}

