/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.update;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.changelog.SvnChangeLogCommand;
import org.apache.maven.scm.provider.svn.svnexe.command.update.SvnUpdateConsumer;
import org.apache.maven.scm.provider.svn.util.SvnUtil;
import org.apache.maven.scm.providers.svn.settings.Settings;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnUpdateCommand
extends AbstractUpdateCommand
implements SvnCommand {
    @Override
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        int exitCode;
        Commandline cl = SvnUpdateCommand.createCommandLine((SvnScmProviderRepository)repo, fileSet.getBasedir(), version);
        SvnUpdateConsumer consumer = new SvnUpdateConsumer(fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            if (Os.isFamily("windows")) {
                this.logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
            }
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, consumer, stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", ex);
        }
        if (exitCode != 0) {
            return new UpdateScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        UpdateScmResultWithRevision result = new UpdateScmResultWithRevision(cl.toString(), consumer.getUpdatedFiles(), String.valueOf(consumer.getRevision()));
        result.setChanges(consumer.getChangeSets());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("changeSets " + consumer.getChangeSets());
        }
        return result;
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, ScmVersion version) {
        Settings settings = SvnUtil.getSettings();
        String workingDir = workingDirectory.getAbsolutePath();
        if (settings.isUseCygwinPath()) {
            workingDir = settings.getCygwinMountPath() + "/" + workingDir;
            workingDir = StringUtils.replace(workingDir, ":", "");
            workingDir = StringUtils.replace(workingDir, "\\", "/");
        }
        if (version != null && StringUtils.isEmpty(version.getName())) {
            version = null;
        }
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        if (version == null || SvnTagBranchUtils.isRevisionSpecifier(version)) {
            cl.createArg().setValue("update");
            if (version != null && StringUtils.isNotEmpty(version.getName())) {
                cl.createArg().setValue("-r");
                cl.createArg().setValue(version.getName());
            }
            cl.createArg().setValue(workingDir + "@");
        } else if (version instanceof ScmBranch) {
            cl.createArg().setValue("switch");
            if (version instanceof ScmTag) {
                String tagUrl = SvnTagBranchUtils.resolveTagUrl(repository, (ScmTag)version);
                cl.createArg().setValue(tagUrl + "@");
            } else {
                String branchUrl = SvnTagBranchUtils.resolveBranchUrl(repository, (ScmBranch)version);
                cl.createArg().setValue(branchUrl + "@");
            }
            cl.createArg().setValue(workingDir + "@");
        }
        return cl;
    }

    @Override
    protected ChangeLogCommand getChangeLogCommand() {
        return new SvnChangeLogCommand();
    }
}

