/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.mkdir;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.mkdir.AbstractMkdirCommand;
import org.apache.maven.scm.command.mkdir.MkdirScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.mkdir.SvnMkdirConsumer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnMkdirCommand
extends AbstractMkdirCommand
implements SvnCommand {
    @Override
    protected MkdirScmResult executeMkdirCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean createInLocal) throws ScmException {
        int exitCode;
        File messageFile = FileUtils.createTempFile("maven-scm-", ".commit", null);
        try {
            FileUtils.fileWrite(messageFile.getAbsolutePath(), "UTF-8", message);
        }
        catch (IOException ex) {
            return new MkdirScmResult(null, "Error while making a temporary file for the mkdir message: " + ex.getMessage(), null, false);
        }
        Commandline cl = SvnMkdirCommand.createCommandLine((SvnScmProviderRepository)repository, fileSet, messageFile, createInLocal);
        SvnMkdirConsumer consumer = new SvnMkdirConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            if (Os.isFamily("windows")) {
                this.logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
            }
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, consumer, stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", ex);
        }
        finally {
            try {
                FileUtils.forceDelete(messageFile);
            }
            catch (IOException iOException) {}
        }
        if (exitCode != 0) {
            return new MkdirScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        if (createInLocal) {
            return new MkdirScmResult(cl.toString(), consumer.getCreatedDirs());
        }
        return new MkdirScmResult(cl.toString(), Integer.toString(consumer.getRevision()));
    }

    protected static Commandline createCommandLine(SvnScmProviderRepository repository, ScmFileSet fileSet, File messageFile, boolean createInLocal) {
        if (!fileSet.getBasedir().exists() && !createInLocal) {
            fileSet.getBasedir().mkdirs();
        }
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(fileSet.getBasedir(), repository);
        cl.createArg().setValue("mkdir");
        cl.createArg().setValue("--parents");
        Iterator<File> it = fileSet.getFileList().iterator();
        String dirPath = it.next().getPath();
        if (dirPath != null && Os.isFamily("windows")) {
            dirPath = StringUtils.replace(dirPath, "\\", "/");
        }
        if (!createInLocal) {
            cl.createArg().setValue(repository.getUrl() + "/" + dirPath + "@");
            if (messageFile != null) {
                cl.createArg().setValue("--file");
                cl.createArg().setValue(messageFile.getAbsolutePath());
                cl.createArg().setValue("--encoding");
                cl.createArg().setValue("UTF-8");
            }
        } else {
            cl.createArg().setValue(dirPath);
        }
        return cl;
    }
}

