/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.EventCapturingSinkProxy;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xhtml5BaseParser
extends AbstractXmlParser
implements HtmlMarkup {
    private static final Logger LOGGER = LoggerFactory.getLogger(Xhtml5BaseParser.class);
    private static final Pattern BODYTABLEBORDER_CLASS_PATTERN = Pattern.compile("(?:.*\\s|^)bodyTableBorder(?:\\s.*|$)");
    private static final Set<String> UNMATCHED_XHTML5_ELEMENTS = new HashSet<String>();
    private static final Set<String> UNMATCHED_XHTML5_SIMPLE_ELEMENTS = new HashSet<String>();
    private boolean scriptBlock;
    private boolean isLink;
    private boolean isAnchor;
    private int orderedListDepth = 0;
    private int sectionLevel;
    private int headingLevel;
    private boolean inVerbatim;
    private Stack<String> divStack = new Stack();
    boolean hasDefinitionListItem = false;
    private LinkedList<String> capturedSinkEventNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(Reader source, Sink sink, String reference) throws ParseException {
        this.init();
        try {
            this.capturedSinkEventNames = new LinkedList();
            Sink capturingSink = EventCapturingSinkProxy.newInstance(sink, this.capturedSinkEventNames);
            super.parse(source, capturingSink, reference);
        }
        finally {
            this.setSecondParsing(false);
            this.init();
        }
    }

    @Override
    protected void initXmlParser(XmlPullParser parser) throws XmlPullParserException {
        super.initXmlParser(parser);
    }

    protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        return this.baseStartTag(parser.getName(), attribs, sink);
    }

    protected boolean baseStartTag(String elementName, SinkEventAttributeSet attribs, Sink sink) {
        boolean visited = true;
        if (elementName.equals(HtmlMarkup.ARTICLE.toString())) {
            sink.article(attribs);
        } else if (elementName.equals(HtmlMarkup.NAV.toString())) {
            sink.navigation(attribs);
        } else if (elementName.equals(HtmlMarkup.ASIDE.toString())) {
            sink.sidebar(attribs);
        } else if (elementName.equals(HtmlMarkup.SECTION.toString())) {
            this.handleSectionStart(sink, attribs);
        } else if (elementName.equals(HtmlMarkup.H1.toString())) {
            this.handleHeadingStart(sink, 1, attribs);
        } else if (elementName.equals(HtmlMarkup.H2.toString())) {
            this.handleHeadingStart(sink, 2, attribs);
        } else if (elementName.equals(HtmlMarkup.H3.toString())) {
            this.handleHeadingStart(sink, 3, attribs);
        } else if (elementName.equals(HtmlMarkup.H4.toString())) {
            this.handleHeadingStart(sink, 4, attribs);
        } else if (elementName.equals(HtmlMarkup.H5.toString())) {
            this.handleHeadingStart(sink, 5, attribs);
        } else if (elementName.equals(HtmlMarkup.H6.toString())) {
            this.handleHeadingStart(sink, 6, attribs);
        } else if (elementName.equals(HtmlMarkup.HEADER.toString())) {
            sink.header(attribs);
        } else if (elementName.equals(HtmlMarkup.MAIN.toString())) {
            sink.content(attribs);
        } else if (elementName.equals(HtmlMarkup.FOOTER.toString())) {
            sink.footer(attribs);
        } else if (elementName.equals(HtmlMarkup.EM.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.EMPHASIS);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.STRONG.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.STRONG);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.SMALL.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.SMALL);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.S.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.LINE_THROUGH);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.CITE.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.CITATION);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.Q.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.QUOTE);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.DFN.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.DEFINITION);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.ABBR.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.ABBREVIATION);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.I.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.ITALIC);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.B.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.BOLD);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.CODE.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.CODE);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.VAR.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.VARIABLE);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.SAMP.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.SAMPLE);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.KBD.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.KEYBOARD);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.SUP.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.SUPERSCRIPT);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.SUB.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.SUBSCRIPT);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.U.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.ANNOTATION);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.MARK.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.HIGHLIGHT);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.RUBY.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.RB.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY_BASE);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.RT.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY_TEXT);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.RTC.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY_TEXT_CONTAINER);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.RP.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.RUBY_PARANTHESES);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.BDI.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.BIDIRECTIONAL_ISOLATION);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.BDO.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.BIDIRECTIONAL_OVERRIDE);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.SPAN.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.PHRASE);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.INS.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.INSERT);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.DEL.toString())) {
            attribs.addAttributes(SinkEventAttributeSet.Semantics.DELETE);
            sink.inline(attribs);
        } else if (elementName.equals(HtmlMarkup.P.toString())) {
            this.handlePStart(sink, attribs);
        } else if (elementName.equals(HtmlMarkup.DIV.toString())) {
            this.handleDivStart(attribs, sink);
        } else if (elementName.equals(HtmlMarkup.PRE.toString())) {
            this.handlePreStart(attribs, sink);
        } else if (elementName.equals(HtmlMarkup.UL.toString())) {
            sink.list(attribs);
        } else if (elementName.equals(HtmlMarkup.OL.toString())) {
            this.handleOLStart(sink, attribs);
        } else if (elementName.equals(HtmlMarkup.LI.toString())) {
            this.handleLIStart(sink, attribs);
        } else if (elementName.equals(HtmlMarkup.DL.toString())) {
            sink.definitionList(attribs);
        } else if (elementName.equals(HtmlMarkup.DT.toString())) {
            if (this.hasDefinitionListItem) {
                sink.definitionListItem_();
            }
            sink.definitionListItem(attribs);
            this.hasDefinitionListItem = true;
            sink.definedTerm(attribs);
        } else if (elementName.equals(HtmlMarkup.DD.toString())) {
            if (!this.hasDefinitionListItem) {
                sink.definitionListItem(attribs);
            }
            sink.definition(attribs);
        } else if (elementName.equals(HtmlMarkup.FIGURE.toString())) {
            sink.figure(attribs);
        } else if (elementName.equals(HtmlMarkup.FIGCAPTION.toString())) {
            sink.figureCaption(attribs);
        } else if (elementName.equals(HtmlMarkup.A.toString())) {
            this.handleAStart(sink, attribs);
        } else if (elementName.equals(HtmlMarkup.TABLE.toString())) {
            this.handleTableStart(sink, attribs);
        } else if (elementName.equals(HtmlMarkup.TR.toString())) {
            sink.tableRow(attribs);
        } else if (elementName.equals(HtmlMarkup.TH.toString())) {
            sink.tableHeaderCell(attribs);
        } else if (elementName.equals(HtmlMarkup.TD.toString())) {
            sink.tableCell(attribs);
        } else if (elementName.equals(HtmlMarkup.CAPTION.toString())) {
            sink.tableCaption(attribs);
        } else if (elementName.equals(HtmlMarkup.BR.toString())) {
            sink.lineBreak(attribs);
        } else if (elementName.equals(HtmlMarkup.WBR.toString())) {
            sink.lineBreakOpportunity(attribs);
        } else if (elementName.equals(HtmlMarkup.HR.toString())) {
            sink.horizontalRule(attribs);
        } else if (elementName.equals(HtmlMarkup.IMG.toString())) {
            this.handleImgStart(sink, attribs);
        } else if (elementName.equals(HtmlMarkup.BLOCKQUOTE.toString())) {
            sink.blockquote(attribs);
        } else if (UNMATCHED_XHTML5_ELEMENTS.contains(elementName)) {
            this.handleUnknown(elementName, attribs, sink, 2);
        } else if (UNMATCHED_XHTML5_SIMPLE_ELEMENTS.contains(elementName)) {
            this.handleUnknown(elementName, attribs, sink, 1);
        } else if (elementName.equals(HtmlMarkup.SCRIPT.toString()) || elementName.equals(HtmlMarkup.STYLE.toString())) {
            this.handleUnknown(elementName, attribs, sink, 2);
            this.scriptBlock = true;
        } else {
            visited = false;
        }
        return visited;
    }

    protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        return this.baseEndTag(parser.getName(), attribs, sink);
    }

    protected boolean baseEndTag(String elementName, SinkEventAttributeSet attribs, Sink sink) {
        boolean visited = true;
        if (elementName.equals(HtmlMarkup.P.toString())) {
            sink.paragraph_();
        } else if (elementName.equals(HtmlMarkup.DIV.toString())) {
            this.handleDivEnd(sink);
        } else if (elementName.equals(HtmlMarkup.PRE.toString())) {
            this.verbatim_();
            sink.verbatim_();
        } else if (elementName.equals(HtmlMarkup.UL.toString())) {
            sink.list_();
        } else if (elementName.equals(HtmlMarkup.OL.toString())) {
            sink.numberedList_();
            --this.orderedListDepth;
        } else if (elementName.equals(HtmlMarkup.LI.toString())) {
            this.handleListItemEnd(sink);
        } else if (elementName.equals(HtmlMarkup.DL.toString())) {
            if (this.hasDefinitionListItem) {
                sink.definitionListItem_();
                this.hasDefinitionListItem = false;
            }
            sink.definitionList_();
        } else if (elementName.equals(HtmlMarkup.DT.toString())) {
            sink.definedTerm_();
        } else if (elementName.equals(HtmlMarkup.DD.toString())) {
            sink.definition_();
            sink.definitionListItem_();
            this.hasDefinitionListItem = false;
        } else if (elementName.equals(HtmlMarkup.FIGURE.toString())) {
            sink.figure_();
        } else if (elementName.equals(HtmlMarkup.FIGCAPTION.toString())) {
            sink.figureCaption_();
        } else if (elementName.equals(HtmlMarkup.A.toString())) {
            this.handleAEnd(sink);
        } else if (elementName.equals(HtmlMarkup.EM.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.STRONG.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.SMALL.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.S.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.CITE.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.Q.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.DFN.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.ABBR.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.I.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.B.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.CODE.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.VAR.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.SAMP.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.KBD.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.SUP.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.SUB.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.U.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.MARK.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.RUBY.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.RB.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.RT.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.RTC.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.RP.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.BDI.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.BDO.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.SPAN.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.INS.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.DEL.toString())) {
            sink.inline_();
        } else if (elementName.equals(HtmlMarkup.TABLE.toString())) {
            sink.tableRows_();
            sink.table_();
        } else if (elementName.equals(HtmlMarkup.TR.toString())) {
            sink.tableRow_();
        } else if (elementName.equals(HtmlMarkup.TH.toString())) {
            sink.tableHeaderCell_();
        } else if (elementName.equals(HtmlMarkup.TD.toString())) {
            sink.tableCell_();
        } else if (elementName.equals(HtmlMarkup.CAPTION.toString())) {
            sink.tableCaption_();
        } else if (elementName.equals(HtmlMarkup.ARTICLE.toString())) {
            sink.article_();
        } else if (elementName.equals(HtmlMarkup.NAV.toString())) {
            sink.navigation_();
        } else if (elementName.equals(HtmlMarkup.ASIDE.toString())) {
            sink.sidebar_();
        } else if (elementName.equals(HtmlMarkup.SECTION.toString())) {
            this.handleSectionEnd(sink);
        } else if (elementName.equals(HtmlMarkup.H1.toString())) {
            sink.sectionTitle1_();
        } else if (elementName.equals(HtmlMarkup.H2.toString())) {
            sink.sectionTitle2_();
        } else if (elementName.equals(HtmlMarkup.H3.toString())) {
            sink.sectionTitle3_();
        } else if (elementName.equals(HtmlMarkup.H4.toString())) {
            sink.sectionTitle4_();
        } else if (elementName.equals(HtmlMarkup.H5.toString())) {
            sink.sectionTitle5_();
        } else if (elementName.equals(HtmlMarkup.H6.toString())) {
            sink.sectionTitle6_();
        } else if (elementName.equals(HtmlMarkup.HEADER.toString())) {
            sink.header_();
        } else if (elementName.equals(HtmlMarkup.MAIN.toString())) {
            sink.content_();
        } else if (elementName.equals(HtmlMarkup.FOOTER.toString())) {
            sink.footer_();
        } else if (elementName.equals(HtmlMarkup.BLOCKQUOTE.toString())) {
            sink.blockquote_();
        } else if (UNMATCHED_XHTML5_ELEMENTS.contains(elementName)) {
            this.handleUnknown(elementName, attribs, sink, 3);
        } else if (elementName.equals(HtmlMarkup.SCRIPT.toString()) || elementName.equals(HtmlMarkup.STYLE.toString())) {
            this.handleUnknown(elementName, attribs, sink, 3);
            this.scriptBlock = false;
        } else {
            visited = false;
        }
        return visited;
    }

    @Override
    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseStartTag(parser, sink)) {
            LOGGER.warn("Unrecognized xml tag <{}> at [{}:{}]", parser.getName(), parser.getLineNumber(), parser.getColumnNumber());
        }
    }

    @Override
    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (!this.baseEndTag(parser, sink)) {
            // empty if block
        }
    }

    @Override
    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (text != null && !text.isEmpty() && !this.isScriptBlock()) {
            sink.text(text);
        }
    }

    @Override
    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if ("PB".equals(text.trim())) {
            sink.pageBreak();
        } else if (this.isEmitComments()) {
            sink.comment(text);
        }
    }

    @Override
    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (this.isScriptBlock()) {
            sink.unknown("CDATA", new Object[]{5, text}, null);
        } else {
            sink.text(text);
        }
    }

    @Deprecated
    protected void consecutiveSections(int newLevel, Sink sink, SinkEventAttributeSet attribs) {
        this.emitHeadingSections(newLevel, sink, true);
    }

    protected void emitHeadingSections(int newLevel, Sink sink, boolean enforceNewSection) {
        int lowerBoundSectionLevel = newLevel;
        if (enforceNewSection && (!this.isLastEventSectionStart() || newLevel < this.headingLevel)) {
            --lowerBoundSectionLevel;
        }
        this.closeOpenHeadingSections(lowerBoundSectionLevel, sink);
        this.openMissingHeadingSections(newLevel, sink);
        this.headingLevel = newLevel;
    }

    private boolean isLastEventSectionStart() {
        String lastEventName = this.capturedSinkEventNames.pollLast();
        if (lastEventName == null) {
            return false;
        }
        return lastEventName.startsWith("section") && !lastEventName.endsWith("_") && !lastEventName.startsWith("sectionTitle");
    }

    private void closeOpenHeadingSections(int newLevel, Sink sink) {
        while (this.headingLevel > newLevel) {
            if (this.headingLevel >= 1 && this.headingLevel <= 6) {
                sink.section_(this.headingLevel);
            }
            --this.headingLevel;
        }
    }

    private void openMissingHeadingSections(int newLevel, Sink sink) {
        while (this.headingLevel < newLevel) {
            ++this.headingLevel;
            if (this.headingLevel < 1 || this.headingLevel > 6) continue;
            sink.section(this.headingLevel, null);
        }
    }

    protected int getSectionLevel() {
        return this.headingLevel;
    }

    protected void setSectionLevel(int newLevel) {
        this.headingLevel = newLevel;
    }

    protected void verbatim_() {
        this.inVerbatim = false;
    }

    protected void verbatim() {
        this.inVerbatim = true;
    }

    protected boolean isVerbatim() {
        return this.inVerbatim;
    }

    protected boolean isScriptBlock() {
        return this.scriptBlock;
    }

    protected String validAnchor(String id) {
        if (!DoxiaUtils.isValidId(id)) {
            String linkAnchor = DoxiaUtils.encodeId(id);
            LOGGER.debug("Modified invalid link '{}' to '{}'", (Object)id, (Object)linkAnchor);
            return linkAnchor;
        }
        return id;
    }

    @Override
    protected void init() {
        super.init();
        this.scriptBlock = false;
        this.isLink = false;
        this.isAnchor = false;
        this.orderedListDepth = 0;
        this.headingLevel = 0;
        this.inVerbatim = false;
    }

    private void handleAEnd(Sink sink) {
        if (this.isLink) {
            sink.link_();
            this.isLink = false;
        } else if (this.isAnchor) {
            sink.anchor_();
            this.isAnchor = false;
        }
    }

    private void handleAStart(Sink sink, SinkEventAttributeSet attribs) {
        String href = (String)attribs.getAttribute(HTML.Attribute.HREF.toString());
        if (href != null) {
            String hash;
            int hashIndex = href.indexOf(35);
            if (hashIndex != -1 && !DoxiaUtils.isExternalLink(href) && !DoxiaUtils.isValidId(hash = href.substring(hashIndex + 1))) {
                href = href.substring(0, hashIndex) + "#" + DoxiaUtils.encodeId(hash);
                LOGGER.debug("Modified invalid link '{}' to '{}'", (Object)hash, (Object)href);
            }
            sink.link(href, attribs);
            this.isLink = true;
        } else {
            String id = (String)attribs.getAttribute(HTML.Attribute.ID.toString());
            if (id != null) {
                sink.anchor(this.validAnchor(id), attribs);
                this.isAnchor = true;
            }
        }
    }

    private boolean handleDivStart(SinkEventAttributeSet attribs, Sink sink) {
        String divClass = (String)attribs.getAttribute(HTML.Attribute.CLASS.toString());
        this.divStack.push(divClass);
        if ("content".equals(divClass)) {
            SinkEventAttributeSet atts = new SinkEventAttributeSet(attribs);
            atts.removeAttribute("class");
            sink.content(atts);
        }
        if ("verbatim".equals(divClass) || "verbatim source".equals(divClass)) {
            return false;
        }
        sink.division(attribs);
        return true;
    }

    private boolean handleDivEnd(Sink sink) {
        String divClass = this.divStack.pop();
        if ("content".equals(divClass)) {
            sink.content_();
        }
        if ("verbatim".equals(divClass) || "verbatim source".equals(divClass)) {
            return false;
        }
        sink.division_();
        return true;
    }

    private void handleImgStart(Sink sink, SinkEventAttributeSet attribs) {
        String src = (String)attribs.getAttribute(HTML.Attribute.SRC.toString());
        if (src != null) {
            sink.figureGraphics(src, attribs);
        }
    }

    private void handleLIStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.orderedListDepth == 0) {
            sink.listItem(attribs);
        } else {
            sink.numberedListItem(attribs);
        }
    }

    private void handleListItemEnd(Sink sink) {
        if (this.orderedListDepth == 0) {
            sink.listItem_();
        } else {
            sink.numberedListItem_();
        }
    }

    private void handleOLStart(Sink sink, SinkEventAttributeSet attribs) {
        int numbering = 0;
        String style = (String)attribs.getAttribute(HTML.Attribute.STYLE.toString());
        if (style != null) {
            switch (style) {
                case "list-style-type: upper-alpha;": {
                    numbering = 2;
                    break;
                }
                case "list-style-type: lower-alpha;": {
                    numbering = 1;
                    break;
                }
                case "list-style-type: upper-roman;": {
                    numbering = 4;
                    break;
                }
                case "list-style-type: lower-roman;": {
                    numbering = 3;
                    break;
                }
                case "list-style-type: decimal;": {
                    numbering = 0;
                    break;
                }
            }
        }
        sink.numberedList(numbering, attribs);
        ++this.orderedListDepth;
    }

    private void handlePStart(Sink sink, SinkEventAttributeSet attribs) {
        sink.paragraph(attribs);
    }

    private void handlePreStart(SinkEventAttributeSet attribs, Sink sink) {
        this.verbatim();
        sink.verbatim(attribs);
    }

    private void handleSectionStart(Sink sink, SinkEventAttributeSet attribs) {
        this.emitHeadingSections(this.sectionLevel, sink, false);
        sink.section(++this.sectionLevel, attribs);
        this.headingLevel = this.sectionLevel;
    }

    private void handleHeadingStart(Sink sink, int level, SinkEventAttributeSet attribs) {
        this.emitHeadingSections(level, sink, true);
        sink.sectionTitle(level, attribs);
    }

    private void handleSectionEnd(Sink sink) {
        this.emitHeadingSections(this.sectionLevel, sink, false);
        sink.section_(this.sectionLevel--);
        this.headingLevel = this.sectionLevel;
    }

    private void handleTableStart(Sink sink, SinkEventAttributeSet attribs) {
        sink.table(attribs);
        String givenTableClass = (String)attribs.getAttribute(HTML.Attribute.CLASS.toString());
        boolean grid = false;
        if (givenTableClass != null && BODYTABLEBORDER_CLASS_PATTERN.matcher(givenTableClass).matches()) {
            grid = true;
        }
        sink.tableRows(null, grid);
    }

    static {
        UNMATCHED_XHTML5_SIMPLE_ELEMENTS.add(HtmlMarkup.AREA.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.AUDIO.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.BUTTON.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.CANVAS.toString());
        UNMATCHED_XHTML5_SIMPLE_ELEMENTS.add(HtmlMarkup.COL.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.COLGROUP.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.COMMAND.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.DATA.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.DATALIST.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.DETAILS.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.DIALOG.toString());
        UNMATCHED_XHTML5_SIMPLE_ELEMENTS.add(HtmlMarkup.EMBED.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.FIELDSET.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.FORM.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.HGROUP.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.IFRAME.toString());
        UNMATCHED_XHTML5_SIMPLE_ELEMENTS.add(HtmlMarkup.INPUT.toString());
        UNMATCHED_XHTML5_SIMPLE_ELEMENTS.add(HtmlMarkup.KEYGEN.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.LABEL.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.LEGEND.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.MAP.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.MENU.toString());
        UNMATCHED_XHTML5_SIMPLE_ELEMENTS.add(HtmlMarkup.MENUITEM.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.METER.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.NOSCRIPT.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.OBJECT.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.OPTGROUP.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.OPTION.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.OUTPUT.toString());
        UNMATCHED_XHTML5_SIMPLE_ELEMENTS.add(HtmlMarkup.PARAM.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.PICTURE.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.PROGRESS.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.SELECT.toString());
        UNMATCHED_XHTML5_SIMPLE_ELEMENTS.add(HtmlMarkup.SOURCE.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.SUMMARY.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.SVG.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.TEMPLATE.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.TEXTAREA.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.TBODY.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.THEAD.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.TFOOT.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.TIME.toString());
        UNMATCHED_XHTML5_SIMPLE_ELEMENTS.add(HtmlMarkup.TRACK.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.VAR.toString());
        UNMATCHED_XHTML5_ELEMENTS.add(HtmlMarkup.VIDEO.toString());
    }
}

