/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.Var;
import org.apache.commons.validator.util.ValidatorUtils;

public class Field
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8502647722530192185L;
    private static final String DEFAULT_ARG = "org.apache.commons.validator.Field.DEFAULT";
    public static final String TOKEN_INDEXED = "[]";
    protected static final String TOKEN_START = "${";
    protected static final String TOKEN_END = "}";
    protected static final String TOKEN_VAR = "var:";
    protected String property;
    protected String indexedProperty;
    protected String indexedListProperty;
    protected String key;
    protected String depends;
    protected int page;
    protected boolean clientValidation = true;
    protected int fieldOrder;
    private final List<String> dependencyList = Collections.synchronizedList(new ArrayList());
    @Deprecated
    protected FastHashMap hVars = new FastHashMap();
    @Deprecated
    protected FastHashMap hMsgs = new FastHashMap();
    protected Map<String, Arg>[] args = new Map[0];

    public void addArg(Arg arg) {
        if (arg == null || arg.getKey() == null || arg.getKey().isEmpty()) {
            return;
        }
        this.determineArgPosition(arg);
        this.ensureArgsCapacity(arg);
        Map<String, Arg> argMap = this.args[arg.getPosition()];
        if (argMap == null) {
            this.args[arg.getPosition()] = argMap = new HashMap<String, Arg>();
        }
        if (arg.getName() == null) {
            argMap.put(DEFAULT_ARG, arg);
        } else {
            argMap.put(arg.getName(), arg);
        }
    }

    public void addMsg(Msg msg) {
        this.getMsgMap().put(msg.getName(), msg);
    }

    public void addVar(String name, String value, String jsType) {
        this.addVar(new Var(name, value, jsType));
    }

    public void addVar(Var v) {
        this.getVarMap().put(v.getName(), v);
    }

    public Object clone() {
        Field field = null;
        try {
            field = (Field)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e.toString(), e);
        }
        Map[] tempMap = new Map[this.args.length];
        field.args = tempMap;
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            if (this.args[i2] == null) continue;
            HashMap<String, Arg> argMap = new HashMap<String, Arg>(this.args[i2]);
            argMap.forEach((validatorName, arg) -> argMap.put((String)validatorName, (Arg)arg.clone()));
            field.args[i2] = argMap;
        }
        field.hVars = ValidatorUtils.copyFastHashMap(this.hVars);
        field.hMsgs = ValidatorUtils.copyFastHashMap(this.hMsgs);
        return field;
    }

    private void determineArgPosition(Arg arg) {
        int position = arg.getPosition();
        if (position >= 0) {
            return;
        }
        if (this.args == null || this.args.length == 0) {
            arg.setPosition(0);
            return;
        }
        String keyName = arg.getName() == null ? DEFAULT_ARG : arg.getName();
        int lastPosition = -1;
        int lastDefault = -1;
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            if (this.args[i2] != null && this.args[i2].containsKey(keyName)) {
                lastPosition = i2;
            }
            if (this.args[i2] == null || !this.args[i2].containsKey(DEFAULT_ARG)) continue;
            lastDefault = i2;
        }
        if (lastPosition < 0) {
            lastPosition = lastDefault;
        }
        arg.setPosition(++lastPosition);
    }

    private void ensureArgsCapacity(Arg arg) {
        if (arg.getPosition() >= this.args.length) {
            Map[] newArgs = new Map[arg.getPosition() + 1];
            System.arraycopy(this.args, 0, newArgs, 0, this.args.length);
            this.args = newArgs;
        }
    }

    public void generateKey() {
        this.key = this.isIndexed() ? this.indexedListProperty + TOKEN_INDEXED + "." + this.property : this.property;
    }

    public Arg getArg(int position) {
        return this.getArg(DEFAULT_ARG, position);
    }

    public Arg getArg(String key, int position) {
        if (position >= this.args.length || this.args[position] == null) {
            return null;
        }
        Arg arg = this.args[position].get(key);
        if (arg == null && key.equals(DEFAULT_ARG)) {
            return null;
        }
        return arg == null ? this.getArg(position) : arg;
    }

    public Arg[] getArgs(String key) {
        Arg[] argList = new Arg[this.args.length];
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            argList[i2] = this.getArg(key, i2);
        }
        return argList;
    }

    public List<String> getDependencyList() {
        return Collections.unmodifiableList(this.dependencyList);
    }

    public String getDepends() {
        return this.depends;
    }

    public int getFieldOrder() {
        return this.fieldOrder;
    }

    public String getIndexedListProperty() {
        return this.indexedListProperty;
    }

    public String getIndexedProperty() {
        return this.indexedProperty;
    }

    Object[] getIndexedProperty(Object bean) throws ValidatorException {
        Object indexProp = null;
        try {
            indexProp = PropertyUtils.getProperty(bean, this.getIndexedListProperty());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ValidatorException(e.getMessage());
        }
        if (indexProp instanceof Collection) {
            return ((Collection)indexProp).toArray();
        }
        if (indexProp.getClass().isArray()) {
            return (Object[])indexProp;
        }
        throw new ValidatorException(this.getKey() + " is not indexed");
    }

    private int getIndexedPropertySize(Object bean) throws ValidatorException {
        Object indexProp = null;
        try {
            indexProp = PropertyUtils.getProperty(bean, this.getIndexedListProperty());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ValidatorException(e.getMessage());
        }
        if (indexProp == null) {
            return 0;
        }
        if (indexProp instanceof Collection) {
            return ((Collection)indexProp).size();
        }
        if (indexProp.getClass().isArray()) {
            return ((Object[])indexProp).length;
        }
        throw new ValidatorException(this.getKey() + " is not indexed");
    }

    public String getKey() {
        if (this.key == null) {
            this.generateKey();
        }
        return this.key;
    }

    public Msg getMessage(String key) {
        return this.getMsgMap().get(key);
    }

    public Map<String, Msg> getMessages() {
        return Collections.unmodifiableMap(this.getMsgMap());
    }

    public String getMsg(String key) {
        Msg msg = this.getMessage(key);
        return msg == null ? null : msg.getKey();
    }

    protected Map<String, Msg> getMsgMap() {
        return this.hMsgs;
    }

    public int getPage() {
        return this.page;
    }

    public String getProperty() {
        return this.property;
    }

    public Var getVar(String mainKey) {
        return this.getVarMap().get(mainKey);
    }

    protected Map<String, Var> getVarMap() {
        return this.hVars;
    }

    public Map<String, Var> getVars() {
        return Collections.unmodifiableMap(this.getVarMap());
    }

    public String getVarValue(String mainKey) {
        String value = null;
        Var v = this.getVarMap().get(mainKey);
        if (v != null) {
            value = v.getValue();
        }
        return value;
    }

    private void handleMissingAction(String name) throws ValidatorException {
        throw new ValidatorException("No ValidatorAction named " + name + " found for field " + this.getProperty());
    }

    public boolean isClientValidation() {
        return this.clientValidation;
    }

    public boolean isDependency(String validatorName) {
        return this.dependencyList.contains(validatorName);
    }

    public boolean isIndexed() {
        return this.indexedListProperty != null && !this.indexedListProperty.isEmpty();
    }

    void process(Map<String, String> globalConstants, Map<String, String> constants) {
        String replaceValue;
        String key2;
        String key1;
        this.hMsgs.setFast(false);
        this.hVars.setFast(true);
        this.generateKey();
        for (Map.Entry<String, String> entry : constants.entrySet()) {
            key1 = entry.getKey();
            key2 = TOKEN_START + key1 + TOKEN_END;
            replaceValue = entry.getValue();
            this.property = ValidatorUtils.replace(this.property, key2, replaceValue);
            this.processVars(key2, replaceValue);
            this.processMessageComponents(key2, replaceValue);
        }
        for (Map.Entry<String, String> entry : globalConstants.entrySet()) {
            key1 = entry.getKey();
            key2 = TOKEN_START + key1 + TOKEN_END;
            replaceValue = entry.getValue();
            this.property = ValidatorUtils.replace(this.property, key2, replaceValue);
            this.processVars(key2, replaceValue);
            this.processMessageComponents(key2, replaceValue);
        }
        for (String key12 : this.getVarMap().keySet()) {
            String key22 = "${var:" + key12 + TOKEN_END;
            Var var = this.getVar(key12);
            replaceValue = var.getValue();
            this.processMessageComponents(key22, replaceValue);
        }
        this.hMsgs.setFast(true);
    }

    private void processArg(String key, String replaceValue) {
        for (Map<String, Arg> argMap : this.args) {
            if (argMap == null) continue;
            for (Arg arg : argMap.values()) {
                if (arg == null) continue;
                arg.setKey(ValidatorUtils.replace(arg.getKey(), key, replaceValue));
            }
        }
    }

    private void processMessageComponents(String key, String replaceValue) {
        String varKey = "${var:";
        if (key != null && !key.startsWith("${var:")) {
            for (Msg msg : this.getMsgMap().values()) {
                msg.setKey(ValidatorUtils.replace(msg.getKey(), key, replaceValue));
            }
        }
        this.processArg(key, replaceValue);
    }

    private void processVars(String key, String replaceValue) {
        for (String varKey : this.getVarMap().keySet()) {
            Var var = this.getVar(varKey);
            var.setValue(ValidatorUtils.replace(var.getValue(), key, replaceValue));
        }
    }

    private boolean runDependentValidators(ValidatorAction va, ValidatorResults results, Map<String, ValidatorAction> actions, Map<String, Object> params, int pos) throws ValidatorException {
        List<String> dependentValidators = va.getDependencyList();
        if (dependentValidators.isEmpty()) {
            return true;
        }
        for (String depend : dependentValidators) {
            ValidatorAction action = actions.get(depend);
            if (action == null) {
                this.handleMissingAction(depend);
            }
            if (this.validateForRule(action, results, actions, params, pos)) continue;
            return false;
        }
        return true;
    }

    public void setClientValidation(boolean clientValidation) {
        this.clientValidation = clientValidation;
    }

    public void setDepends(String depends) {
        this.depends = depends;
        this.dependencyList.clear();
        StringTokenizer st = new StringTokenizer(depends, ",");
        while (st.hasMoreTokens()) {
            String depend = st.nextToken().trim();
            if (depend == null || depend.isEmpty()) continue;
            this.dependencyList.add(depend);
        }
    }

    public void setFieldOrder(int fieldOrder) {
        this.fieldOrder = fieldOrder;
    }

    public void setIndexedListProperty(String indexedListProperty) {
        this.indexedListProperty = indexedListProperty;
    }

    public void setIndexedProperty(String indexedProperty) {
        this.indexedProperty = indexedProperty;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String toString() {
        StringBuilder results = new StringBuilder();
        results.append("\t\tkey = " + this.key + "\n");
        results.append("\t\tproperty = " + this.property + "\n");
        results.append("\t\tindexedProperty = " + this.indexedProperty + "\n");
        results.append("\t\tindexedListProperty = " + this.indexedListProperty + "\n");
        results.append("\t\tdepends = " + this.depends + "\n");
        results.append("\t\tpage = " + this.page + "\n");
        results.append("\t\tfieldOrder = " + this.fieldOrder + "\n");
        if (this.hVars != null) {
            results.append("\t\tVars:\n");
            for (String key1 : this.getVarMap().keySet()) {
                results.append("\t\t\t");
                results.append((Object)key1);
                results.append("=");
                results.append(this.getVarMap().get(key1));
                results.append("\n");
            }
        }
        return results.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidatorResults validate(Map<String, Object> params, Map<String, ValidatorAction> actions) throws ValidatorException {
        if (this.getDepends() == null) {
            return new ValidatorResults();
        }
        ValidatorResults allResults = new ValidatorResults();
        Object bean = params.get("java.lang.Object");
        int numberOfFieldsToValidate = this.isIndexed() ? this.getIndexedPropertySize(bean) : 1;
        for (int fieldNumber = 0; fieldNumber < numberOfFieldsToValidate; ++fieldNumber) {
            ValidatorResults results = new ValidatorResults();
            List<String> list = this.dependencyList;
            synchronized (list) {
                for (String depend : this.dependencyList) {
                    boolean good;
                    ValidatorAction action = actions.get(depend);
                    if (action == null) {
                        this.handleMissingAction(depend);
                    }
                    if (good = this.validateForRule(action, results, actions, params, fieldNumber)) continue;
                    allResults.merge(results);
                    return allResults;
                }
            }
            allResults.merge(results);
        }
        return allResults;
    }

    private boolean validateForRule(ValidatorAction va, ValidatorResults results, Map<String, ValidatorAction> actions, Map<String, Object> params, int pos) throws ValidatorException {
        ValidatorResult result = results.getValidatorResult(this.getKey());
        if (result != null && result.containsAction(va.getName())) {
            return result.isValid(va.getName());
        }
        if (!this.runDependentValidators(va, results, actions, params, pos)) {
            return false;
        }
        return va.executeValidationMethod(this, params, results, pos);
    }
}

