/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPropertiesRule
extends Rule {
    private final Map<String, String> aliases = new HashMap<String, String>();
    private boolean ignoreMissingProperty = true;

    public SetPropertiesRule() {
    }

    public SetPropertiesRule(String attributeName, String propertyName) {
        this.aliases.put(attributeName, propertyName);
    }

    public SetPropertiesRule(String[] attributeNames, String[] propertyNames) {
        int size = attributeNames.length;
        for (int i2 = 0; i2 < size; ++i2) {
            String propName = null;
            if (i2 < propertyNames.length) {
                propName = propertyNames[i2];
            }
            this.aliases.put(attributeNames[i2], propName);
        }
    }

    public SetPropertiesRule(Map<String, String> aliases) {
        if (aliases != null && !aliases.isEmpty()) {
            this.aliases.putAll(aliases);
        }
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            Object top;
            boolean test;
            String attributeName = attributes.getLocalName(i2);
            if ("".equals(attributeName)) {
                attributeName = attributes.getQName(i2);
            }
            String value = attributes.getValue(i2);
            if (this.aliases.containsKey(attributeName)) {
                attributeName = this.aliases.get(attributeName);
            }
            if (this.getDigester().getLogger().isDebugEnabled()) {
                this.getDigester().getLogger().debug(String.format("[SetPropertiesRule]{%s} Setting property '%s' to '%s'", this.getDigester().getMatch(), attributeName, attributeName));
            }
            if (!this.ignoreMissingProperty && attributeName != null && !(test = PropertyUtils.isWriteable(top = this.getDigester().peek(), attributeName))) {
                throw new NoSuchMethodException("Property " + attributeName + " can't be set");
            }
            if (attributeName == null) continue;
            values.put(attributeName, value);
        }
        Object top = this.getDigester().peek();
        if (this.getDigester().getLogger().isDebugEnabled()) {
            if (top != null) {
                this.getDigester().getLogger().debug(String.format("[SetPropertiesRule]{%s} Set '%s' properties", this.getDigester().getMatch(), top.getClass().getName()));
            } else {
                this.getDigester().getLogger().debug(String.format("[SetPropertiesRule]{%s} Set NULL properties", this.getDigester().getMatch()));
            }
        }
        BeanUtils.populate(top, values);
    }

    public void addAlias(String attributeName, String propertyName) {
        this.aliases.put(attributeName, propertyName);
    }

    public String toString() {
        return String.format("SetPropertiesRule[aliases=%s, ignoreMissingProperty=%s]", this.aliases, this.ignoreMissingProperty);
    }

    public boolean isIgnoreMissingProperty() {
        return this.ignoreMissingProperty;
    }

    public void setIgnoreMissingProperty(boolean ignoreMissingProperty) {
        this.ignoreMissingProperty = ignoreMissingProperty;
    }
}

