/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class SaslPlainServer
implements SaslServer {
    private CallbackHandler cbh;
    private boolean completed;
    private String authz;

    private SaslPlainServer(CallbackHandler callback) {
        this.cbh = callback;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (response != null && response.length == 0) {
            return new byte[0];
        }
        if (this.completed) {
            throw new IllegalStateException("PLAIN already completed");
        }
        if (response == null) {
            throw new IllegalArgumentException("Received null response");
        }
        try {
            String[] chunks = new String(response, StandardCharsets.UTF_8).split("\u0000", 3);
            if (chunks.length != 3) {
                throw new IllegalArgumentException("error parsing response (got " + chunks.length + " chunks out of " + response.length + ")");
            }
            if (chunks[0] == null || chunks[0].isEmpty()) {
                chunks[0] = chunks[1];
            }
            NameCallback nc = new NameCallback("SASL PLAIN");
            nc.setName(chunks[1]);
            PasswordCallback pc = new PasswordCallback("SASL PLAIN", false);
            pc.setPassword(chunks[2].toCharArray());
            AuthorizeCallback ac = new AuthorizeCallback(chunks[1], chunks[0]);
            this.cbh.handle(new Callback[]{nc, pc, ac});
            if (ac.isAuthorized()) {
                this.authz = ac.getAuthorizedID();
            }
        }
        catch (Exception e) {
            throw new SaslException("PLAIN auth failed: " + e.getMessage(), e);
        }
        finally {
            this.completed = true;
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.completed) {
            throw new IllegalStateException("PLAIN authentication not yet completed");
        }
        return this.authz;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.completed) {
            throw new IllegalStateException("PLAIN authentication not yet completed");
        }
        return "javax.security.sasl.qop".equals(propName) ? "auth" : null;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        throw new IllegalStateException("PLAIN supports no integrity or privacy");
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        throw new IllegalStateException("PLAIN supports no integrity or privacy");
    }

    @Override
    public void dispose() {
        this.cbh = null;
        this.authz = null;
    }

    public static class SaslPlainServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mech, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) {
            return "PLAIN".equals(mech) ? new SaslPlainServer(cbh) : null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            if (props == null || "false".equalsIgnoreCase(props.get("javax.security.sasl.policy.noplaintext").toString())) {
                return new String[]{"PLAIN"};
            }
            return new String[0];
        }
    }

    public static class SecurityProvider
    extends Provider {
        public SecurityProvider() {
            super("SaslPlainServer", 1.0, "SASL PLAIN Authentication Server");
            this.put("SaslServerFactory.PLAIN", SaslPlainServerFactory.class.getName());
        }
    }
}

