/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router.operation;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AbstractRedundancyOperation;
import net.messagevortex.asn1.AddRedundancyOperation;
import net.messagevortex.asn1.PayloadChunk;
import net.messagevortex.asn1.SymmetricKey;
import net.messagevortex.asn1.VortexMessage;
import net.messagevortex.asn1.encryption.Prng;
import net.messagevortex.router.operation.AbstractOperation;
import net.messagevortex.router.operation.GaloisFieldMathMode;
import net.messagevortex.router.operation.MathMode;
import net.messagevortex.router.operation.Matrix;
import net.messagevortex.router.operation.RedundancyMatrix;

public class AddRedundancy
extends AbstractOperation
implements Serializable {
    private static final long MAX_SIZE = 0x100000000L;
    private static final Prng localPrng = new SimplePrng();
    public static final long serialVersionUID = 100000000018L;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    AbstractRedundancyOperation operation;

    public AddRedundancy(AddRedundancyOperation op) {
        this.operation = op;
    }

    @Override
    public boolean canRun() {
        return this.payload.getPayload(this.operation.getInputId()) != null;
    }

    @Override
    public int[] getOutputId() {
        int[] ret = new int[this.operation.getDataStripes() + this.operation.getRedundancy()];
        int id = this.operation.getOutputId();
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = id + i2;
        }
        return ret;
    }

    @Override
    public int[] getInputId() {
        int[] ret = new int[1];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = this.operation.getInputId() + i2;
        }
        return ret;
    }

    @Override
    public int[] execute(int[] id) {
        if (!this.canRun() || id == null) {
            return new int[0];
        }
        LOGGER.log(Level.INFO, "executing add redundancy operation (" + String.valueOf(this) + ")");
        byte[] in = this.payload.getPayload(this.operation.getInputId()).getPayload();
        Matrix out = this.executeInt(in);
        LOGGER.log(Level.INFO, "  setting output chunks");
        int tot = 0;
        assert (out.getY() == this.operation.getRedundancy() + this.operation.getDataStripes());
        try {
            for (int i2 = 0; i2 < out.getY(); ++i2) {
                int plid = this.operation.getOutputId() + i2;
                byte[] b = this.operation.getKeys()[i2].encrypt(out.getRowAsByteArray(i2));
                this.payload.setCalculatedPayload(plid, new PayloadChunk(plid, b, this.getUsagePeriod()));
                tot += b.length;
            }
        }
        catch (IOException ioe) {
            for (int i3 : this.getOutputId()) {
                this.payload.setCalculatedPayload(i3, null);
            }
            LOGGER.log(Level.INFO, "  failed");
            return new int[0];
        }
        LOGGER.log(Level.INFO, "  done (chunk size: " + out.getRowAsByteArray(0).length + "; total:" + tot + ")");
        return this.getOutputId();
    }

    public static byte[] execute(byte[] in, int redundancy, int dataStripes, int gf) {
        AddRedundancy ar = new AddRedundancy(new AddRedundancyOperation(-1, redundancy, dataStripes, new Vector<SymmetricKey>(), -1, gf));
        LOGGER.log(Level.INFO, "executing add redundancy operation (" + String.valueOf(ar) + ")");
        Matrix out = ar.executeInt(in);
        LOGGER.log(Level.INFO, "  setting output chunks");
        int tot = 0;
        byte[] totArray = new byte[]{};
        for (int i2 = 0; i2 < out.getY(); ++i2) {
            byte[] b = out.getRowAsByteArray(i2);
            byte[] t = new byte[tot + b.length];
            System.arraycopy(totArray, 0, t, 0, totArray.length);
            System.arraycopy(b, 0, t, totArray.length, b.length);
            totArray = t;
            tot += b.length;
        }
        LOGGER.log(Level.INFO, "  done (chunk size: " + out.getRowAsByteArray(0).length + "; total:" + tot + ")");
        return totArray;
    }

    private Matrix executeInt(byte[] in) {
        int keySize;
        int paddingSize = 4;
        int size = in.length + paddingSize;
        int n = keySize = this.operation.getKeys().length != 0 ? this.operation.getKeys()[1].getKeySize() / 8 : 32;
        if (size % (keySize * this.operation.getDataStripes()) > 0) {
            size = keySize * this.operation.getDataStripes() * (size / (keySize * this.operation.getDataStripes()) + 1);
        }
        byte[] in2 = new byte[size];
        byte[] pad = VortexMessage.getLongAsBytes(in.length, paddingSize);
        String msg = "  calculated padded size (original: " + in.length + "; blocks: " + this.operation.getDataStripes() + "; block size: " + keySize + "; padded size: " + size + ")";
        LOGGER.log(Level.INFO, msg);
        System.arraycopy(pad, 0, in2, 0, paddingSize);
        System.arraycopy(in, 0, in2, paddingSize, in.length);
        for (int i2 = 0; i2 < in2.length - in.length - paddingSize; ++i2) {
            in2[i2 + paddingSize + in.length] = pad[i2 % pad.length];
        }
        GaloisFieldMathMode mm = GaloisFieldMathMode.getGaloisFieldMathMode(this.operation.getGfSize());
        LOGGER.log(Level.INFO, "  preparing data matrixContent");
        Matrix data = new Matrix(in2.length / this.operation.getDataStripes(), this.operation.getDataStripes(), (MathMode)mm, in2);
        LOGGER.log(Level.INFO, "  data matrixContent is " + data.getX() + "x" + data.getY());
        LOGGER.log(Level.INFO, "  preparing redundancy matrixContent");
        RedundancyMatrix r = new RedundancyMatrix(this.operation.getDataStripes(), this.operation.getDataStripes() + this.operation.getRedundancy(), mm);
        LOGGER.log(Level.INFO, "  redundancy matrixContent is " + r.getX() + "x" + r.getY());
        LOGGER.log(Level.INFO, "  calculating");
        return r.mul(data);
    }

    private static long gcd(long n1, long n2) {
        long gcd = 1L;
        int i2 = 1;
        while ((long)i2 <= n1 && (long)i2 <= n2) {
            if (n1 % (long)i2 == 0L && n2 % (long)i2 == 0L) {
                gcd = i2;
            }
            ++i2;
        }
        return gcd;
    }

    private static long lcm(long n1, long n2) {
        long gcd = AddRedundancy.gcd(n1, n2);
        return n1 * n2 / gcd;
    }

    public static byte[] pad(int blocksize, int numberOfOutBlocks, byte[] data, Prng prng, int c1, int c2) {
        int a;
        LOGGER.log(Level.FINEST, "starting padding of " + data.length + " bytes with blocksize " + blocksize + " and output block count with " + numberOfOutBlocks);
        if (c1 < 0) {
            c1 = 0;
        }
        if (c2 < 0) {
            c2 = 0;
        }
        long outRowSize = AddRedundancy.lcm(blocksize, numberOfOutBlocks);
        long containerSize = (long)Math.ceil(((double)data.length + (double)c2) / (double)outRowSize) * outRowSize;
        LOGGER.log(Level.FINEST, "container size of padded array is " + (containerSize + 4L) + " bytes (c1: " + c1 + "; c2: " + c2 + ")");
        long modOp = (long)Math.floor((4.294967295E9 - (double)data.length) / (double)containerSize) * containerSize;
        long pval = containerSize == 0L ? ThreadLocalRandom.current().nextLong(0x100000000L) : new BigInteger("" + data.length).add(new BigInteger("" + c1).multiply(new BigInteger("" + containerSize))).mod(new BigInteger("" + modOp)).longValue();
        LOGGER.log(Level.FINEST, "Padding value is " + pval);
        assert (modOp < 0x100000000L) : "modulo value too big (" + modOp + ">4294967296)";
        assert (pval < 0x100000000L) : "Padding value too big (" + pval + ">4294967296)";
        byte[] out = new byte[(int)containerSize + 4];
        out[0] = (byte)((pval & 0xFFL) - 128L);
        out[1] = (byte)((pval >>> 8 & 0xFFL) - 128L);
        out[2] = (byte)((pval >>> 16 & 0xFFL) - 128L);
        out[3] = (byte)((pval >>> 24 & 0xFFL) - 128L);
        LOGGER.log(Level.FINEST, "Encoded padding value is " + out[0] + ";" + out[1] + ";" + out[2] + ";" + out[3]);
        for (a = 4; a < data.length + 4; ++a) {
            out[a] = data[a - 4];
        }
        if (prng == null) {
            prng = localPrng;
        }
        for (a = 4 + data.length; a < out.length; ++a) {
            byte val;
            out[a] = val = prng.nextByte();
            if (a >= 8 + data.length) continue;
            LOGGER.log(Level.FINEST, "  Padding start value is " + val + " at " + a);
        }
        LOGGER.log(Level.FINEST, "Padding is done up to size " + out.length);
        return out;
    }

    public static byte[] unpad(int blocksize, int numberOfOutBlocks, byte[] in, Prng prng) throws IOException {
        int a;
        LOGGER.log(Level.FINEST, "starting unpadding of " + in.length + " bytes");
        LOGGER.log(Level.FINEST, "Encoded padding value is " + in[0] + ";" + in[1] + ";" + in[2] + ";" + in[3]);
        long size = (long)in[0] + 128L + ((long)in[1] + 128L) * 256L + ((long)in[2] + 128L) * 256L * 256L + ((long)in[3] + 128L) * 256L * 256L * 256L;
        LOGGER.log(Level.FINEST, "Padding value is " + size);
        size = in.length > 4 ? (size %= (long)(in.length - 4)) : 0L;
        LOGGER.log(Level.FINEST, "size is " + size + " bytes");
        byte[] out = new byte[(int)size];
        for (a = 4; a < out.length + 4; ++a) {
            out[a - 4] = in[a];
        }
        if (prng != null) {
            for (a = out.length + 4; a < in.length; ++a) {
                byte val = prng.nextByte();
                if (a < 8 + out.length) {
                    LOGGER.log(Level.FINEST, "  Padding start value is " + val + " at " + a);
                }
                if (in[a] == val) continue;
                throw new IOException("error verifying padding at position " + a + " in container");
            }
        }
        return out;
    }

    public String toString() {
        return this.getInputId()[0] + "->addRedundancy(" + this.getOutputId().length + ")->" + this.getOutputId()[0];
    }

    public static class SimplePrng
    implements Prng {
        private final Random sr = new Random();
        private final long seed;

        public SimplePrng() {
            this.seed = this.sr.nextLong();
            this.sr.setSeed(this.seed);
        }

        public SimplePrng(long seed) {
            this.seed = seed;
        }

        @Override
        public synchronized byte nextByte() {
            byte[] a = new byte[1];
            this.sr.nextBytes(a);
            return a[0];
        }

        @Override
        public void reset() {
            this.sr.setSeed(this.seed);
        }
    }
}

