/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.Serializable;
import net.messagevortex.asn1.Operation;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class MergePayloadOperation
extends Operation
implements Serializable {
    public static final long serialVersionUID = 100000000024L;
    int originalFirstId = -1;
    int originalSecondId = -1;
    int newId = -1;

    MergePayloadOperation() {
    }

    public MergePayloadOperation(ASN1Encodable object) {
        this.parse(object);
    }

    @Override
    protected final void parse(ASN1Encodable to) {
        ASN1Sequence s1 = ASN1Sequence.getInstance(to);
        int i2 = 0;
        this.originalFirstId = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
        this.originalSecondId = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
        this.newId = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumptype) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        sb.append(prefix).append("  originalFirstId ").append(this.originalFirstId).append(',').append("\r\n");
        sb.append(prefix).append("  originalSecondId ").append(this.originalSecondId).append(',').append("\r\n");
        sb.append(prefix).append("  newId ").append(this.newId).append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) {
        ASN1EncodableVector s1 = new ASN1EncodableVector();
        s1.add(new ASN1Integer(this.originalFirstId));
        s1.add(new ASN1Integer(this.originalSecondId));
        s1.add(new ASN1Integer(this.newId));
        return new DERSequence(s1);
    }

    @Override
    public Operation getNewInstance(ASN1Encodable object) {
        return new MergePayloadOperation(object);
    }
}

