/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.BlendingParameter;
import net.messagevortex.asn1.Dumpable;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;

public class BlendingSpec
extends AbstractBlock
implements Serializable,
Dumpable {
    public static final long serialVersionUID = 100000000005L;
    private String recipientAddress = null;
    private String media = "smtp:";
    private String blendingType = "attach";
    private BlendingParameter[] blendingParameter = new BlendingParameter[0];

    public BlendingSpec(ASN1Encodable to) throws IOException {
        this.parse(to);
    }

    public BlendingSpec(String blendingEndpointAddress) {
        this.recipientAddress = blendingEndpointAddress;
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        ASN1Sequence s1 = ASN1Sequence.getInstance(to);
        int i2 = 0;
        ASN1Sequence s2 = ASN1Sequence.getInstance(s1.getObjectAt(i2++));
        int i22 = 0;
        this.media = DERUTF8String.getInstance(s2.getObjectAt(i22++)).getString();
        this.recipientAddress = DERUTF8String.getInstance(s2.getObjectAt(i22++)).getString();
        this.blendingType = DERUTF8String.getInstance(s1.getObjectAt(i2++)).getString();
        s2 = ASN1Sequence.getInstance(s1.getObjectAt(i2++));
        ArrayList<BlendingParameter> al = new ArrayList<BlendingParameter>(s2.size());
        for (ASN1Encodable e : s2) {
            al.add(new BlendingParameter(e));
        }
        this.blendingParameter = al.toArray(new BlendingParameter[al.size()]);
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(new DERUTF8String(this.media));
        v2.add(new DERUTF8String(this.recipientAddress));
        v.add(new DERSequence(v2));
        v.add(new DERUTF8String(this.blendingType));
        v2 = new ASN1EncodableVector();
        if (this.blendingParameter != null && this.blendingParameter.length > 0) {
            for (BlendingParameter p : this.blendingParameter) {
                v2.add(p.toAsn1Object(dumpType));
            }
        }
        v.add(new DERSequence(v2));
        return new DERSequence(v);
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(" {").append("\r\n");
        sb.append(prefix).append("  target '").append(this.media).append(this.recipientAddress).append("',").append("\r\n");
        sb.append(prefix).append("  blendingType '").append(this.blendingType).append("',").append("\r\n");
        sb.append(prefix).append("  blendingParameter {");
        if (this.blendingParameter != null && this.blendingParameter.length > 0) {
            int i2 = 0;
            for (BlendingParameter p : this.blendingParameter) {
                if (i2 > 0) {
                    sb.append(',');
                }
                sb.append("\r\n");
                sb.append(prefix).append(p.dumpValueNotation("", dumpType));
                ++i2;
            }
            sb.append("\r\n");
        }
        sb.append(prefix).append("  }").append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public String setRecipientAddress(String recipientAddress) {
        String old = this.recipientAddress;
        this.recipientAddress = recipientAddress;
        return old;
    }

    public String getMedia() {
        return this.media;
    }

    public String setMedia(String media) {
        String old = this.media;
        this.media = media;
        return old;
    }

    public String getBlendingType() {
        return this.blendingType;
    }

    public String setBlendingType(String blendingType) {
        String old = this.blendingType;
        this.blendingType = blendingType;
        return old;
    }
}

