/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import net.messagevortex.asn1.Dumpable;
import net.messagevortex.asn1.Operation;
import net.messagevortex.asn1.SymmetricKey;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public abstract class AbstractCryptPayloadOperation
extends Operation
implements Serializable,
Dumpable {
    public static final long serialVersionUID = 100000000033L;
    int originalId = -1;
    SymmetricKey key = null;
    int newId = -1;

    AbstractCryptPayloadOperation() {
    }

    public AbstractCryptPayloadOperation(ASN1Encodable object) throws IOException {
        this.parse(object);
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        ASN1Sequence s1 = ASN1Sequence.getInstance(to);
        int i2 = 0;
        this.originalId = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
        this.key = new SymmetricKey(s1.getObjectAt(i2++).toASN1Primitive().getEncoded());
        this.newId = ASN1Integer.getInstance(s1.getObjectAt(i2)).getValue().intValue();
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumptype) {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getTagNumber()).append("] {").append("\r\n");
        sb.append(prefix).append("  originalId ").append(this.originalId).append(',').append("\r\n");
        sb.append(prefix).append("  key ").append(this.key.dumpValueNotation(prefix + "  ", dumptype)).append(',').append("\r\n");
        sb.append(prefix).append("  newId ").append(this.newId).append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.originalId));
        v.add(this.key.toAsn1Object(dumpType));
        v.add(new ASN1Integer(this.newId));
        return new DERTaggedObject(this.getTagNumber(), new DERSequence(v));
    }

    @Override
    public abstract Operation getNewInstance(ASN1Encodable var1) throws IOException;
}

