/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.json.NonTerminalJsonValue;
import com.hazelcast.internal.serialization.impl.NavigableJsonInputAdapter;
import com.hazelcast.internal.util.collection.WeightedEvictableList;
import com.hazelcast.json.internal.JsonPattern;
import com.hazelcast.json.internal.JsonSchemaHelper;
import com.hazelcast.json.internal.JsonSchemaNode;
import com.hazelcast.query.impl.getters.Getter;
import com.hazelcast.query.impl.getters.JsonGetterContext;
import com.hazelcast.query.impl.getters.JsonGetterContextCache;
import com.hazelcast.query.impl.getters.JsonPathCursor;
import com.hazelcast.query.impl.getters.MultiResult;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.List;

public abstract class AbstractJsonGetter
extends Getter {
    private static final int QUERY_CONTEXT_CACHE_MAX_SIZE = 40;
    private static final int QUERY_CONTEXT_CACHE_CLEANUP_SIZE = 3;
    private static final int PATTERN_TRY_COUNT = 2;
    private final JsonGetterContextCache contextCache = new JsonGetterContextCache(40, 3);

    AbstractJsonGetter(Getter parent) {
        super(parent);
    }

    public static JsonPathCursor getPath(String attributePath) {
        return JsonPathCursor.createCursor(attributePath);
    }

    public static Object convertFromJsonValue(JsonValue value) {
        if (value == null) {
            return null;
        }
        if (value.isNumber()) {
            if (value.toString().contains(".")) {
                return value.asDouble();
            }
            return value.asLong();
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNull()) {
            return null;
        }
        if (value.isString()) {
            return value.asString();
        }
        if (value == NonTerminalJsonValue.INSTANCE) {
            return value;
        }
        throw new IllegalArgumentException("Unknown Json type: " + value);
    }

    abstract JsonParser createParser(Object var1) throws IOException;

    @Override
    Object getValue(Object obj) {
        throw new HazelcastException("Path agnostic value extraction is not supported");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValue(Object obj, String attributePath) {
        JsonPathCursor pathCursor = AbstractJsonGetter.getPath(attributePath);
        try (JsonParser parser = this.createParser(obj);){
            Object object;
            parser.nextToken();
            while (pathCursor.getNext() != null) {
                if (pathCursor.isArray()) {
                    if (pathCursor.isAny()) {
                        object = this.getMultiValue(parser, pathCursor);
                        return object;
                    }
                    JsonToken token = parser.currentToken();
                    if (token != JsonToken.START_ARRAY) {
                        Object var6_9 = null;
                        return var6_9;
                    }
                    token = parser.nextToken();
                    int arrayIndex = pathCursor.getArrayIndex();
                    for (int j = 0; j < arrayIndex; ++j) {
                        if (token == JsonToken.END_ARRAY) {
                            Object var8_12 = null;
                            return var8_12;
                        }
                        parser.skipChildren();
                        token = parser.nextToken();
                    }
                    continue;
                }
                if (this.findAttribute(parser, pathCursor)) continue;
                object = null;
                return object;
            }
            object = AbstractJsonGetter.convertJsonTokenToValue(parser);
            return object;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    Object getValue(Object obj, String attributePath, Object metadata) throws Exception {
        JsonPattern knownPattern;
        if (metadata == null) {
            return this.getValue(obj, attributePath);
        }
        JsonSchemaNode schemaNode = (JsonSchemaNode)metadata;
        NavigableJsonInputAdapter adapter = this.annotate(obj);
        JsonGetterContext queryContext = this.contextCache.getContext(attributePath);
        List<WeightedEvictableList.WeightedItem<JsonPattern>> patternsSnapshot = queryContext.getPatternListSnapshot();
        JsonPathCursor pathCursor = queryContext.newJsonPathCursor();
        for (int i2 = 0; i2 < 2 && i2 < patternsSnapshot.size(); ++i2) {
            WeightedEvictableList.WeightedItem<JsonPattern> patternWeightedItem = patternsSnapshot.get(i2);
            knownPattern = patternWeightedItem.getItem();
            JsonValue value = JsonSchemaHelper.findValueWithPattern(adapter, schemaNode, knownPattern, pathCursor);
            pathCursor.reset();
            if (value == null) continue;
            queryContext.voteFor(patternWeightedItem);
            return AbstractJsonGetter.convertFromJsonValue(value);
        }
        knownPattern = JsonSchemaHelper.createPattern(adapter, schemaNode, pathCursor);
        pathCursor.reset();
        if (knownPattern != null) {
            if (knownPattern.hasAny()) {
                return this.getValue(obj, attributePath);
            }
            queryContext.addOrVoteForPattern(knownPattern);
            return AbstractJsonGetter.convertFromJsonValue(JsonSchemaHelper.findValueWithPattern(adapter, schemaNode, knownPattern, pathCursor));
        }
        return null;
    }

    @Override
    Class<?> getReturnType() {
        throw new IllegalArgumentException("Non applicable for Json getters");
    }

    @Override
    boolean isCacheable() {
        return false;
    }

    int getContextCacheSize() {
        return this.contextCache.getCacheSize();
    }

    protected abstract NavigableJsonInputAdapter annotate(Object var1);

    private boolean findAttribute(JsonParser parser, JsonPathCursor pathCursor) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token != JsonToken.START_OBJECT) {
            return false;
        }
        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME && pathCursor.getCurrent().equals(parser.getCurrentName())) {
                parser.nextToken();
                return true;
            }
            if (!token.isStructStart()) continue;
            parser.skipChildren();
        }
        return false;
    }

    private MultiResult getMultiValue(JsonParser parser, JsonPathCursor pathCursor) throws IOException {
        pathCursor.getNext();
        int initialState = pathCursor.saveState();
        MultiResult<Object> multiResult = new MultiResult<Object>();
        JsonToken currentToken = parser.currentToken();
        if (currentToken != JsonToken.START_ARRAY) {
            return null;
        }
        while ((currentToken = parser.nextToken()) != JsonToken.END_ARRAY && currentToken != null) {
            if (pathCursor.getCurrent() == null) {
                if (currentToken.isScalarValue()) {
                    multiResult.add(AbstractJsonGetter.convertJsonTokenToValue(parser));
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (currentToken == JsonToken.START_OBJECT) {
                boolean found = true;
                int subpathElementsMatched = 0;
                do {
                    if (pathCursor.isArray()) {
                        throw new UnsupportedOperationException("Nested arrays in JSON paths are not supported");
                    }
                    if (!this.findAttribute(parser, pathCursor)) {
                        found = false;
                        break;
                    }
                    ++subpathElementsMatched;
                } while (pathCursor.getNext() != null);
                if (found) {
                    multiResult.add(AbstractJsonGetter.convertJsonTokenToValue(parser));
                    if (!parser.currentToken().isScalarValue()) {
                        parser.skipChildren();
                    }
                }
                for (int unnestCounter = 0; unnestCounter < subpathElementsMatched; ++unnestCounter) {
                    AbstractJsonGetter.advanceToTheEndOfCurrentObject(parser);
                }
                pathCursor.restoreState(initialState);
                continue;
            }
            if (currentToken != JsonToken.START_ARRAY) continue;
            if (pathCursor.isArray()) {
                throw new UnsupportedOperationException("Nested arrays in JSON paths are not supported");
            }
            parser.skipChildren();
        }
        return multiResult;
    }

    private static void advanceToTheEndOfCurrentObject(JsonParser parser) throws IOException {
        JsonToken currentToken;
        while ((currentToken = parser.nextToken()) != JsonToken.END_OBJECT && currentToken != null) {
            if (!currentToken.isStructStart()) continue;
            parser.skipChildren();
        }
    }

    private static Object convertJsonTokenToValue(JsonParser parser) throws IOException {
        int token = parser.currentTokenId();
        return switch (token) {
            case 6 -> parser.getValueAsString();
            case 7 -> parser.getLongValue();
            case 8 -> parser.getValueAsDouble();
            case 9 -> true;
            case 10 -> false;
            case 11 -> null;
            default -> NonTerminalJsonValue.INSTANCE;
        };
    }
}

