/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobClassLoaderService;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class InitExecutionOperation
extends AsyncJobOperation {
    private long executionId;
    private int coordinatorMemberListVersion;
    private Version coordinatorVersion;
    private Set<MemberInfo> participants;
    private Data serializedPlan;
    private boolean isLightJob;

    public InitExecutionOperation() {
    }

    public InitExecutionOperation(long jobId, long executionId, int coordinatorMemberListVersion, Version coordinatorVersion, Set<MemberInfo> participants, Data serializedPlan, boolean isLightJob) {
        super(jobId);
        this.executionId = executionId;
        this.coordinatorMemberListVersion = coordinatorMemberListVersion;
        this.coordinatorVersion = coordinatorVersion;
        this.participants = participants;
        this.serializedPlan = serializedPlan;
        this.isLightJob = isLightJob;
    }

    @Override
    protected CompletableFuture<?> doRun() {
        ILogger logger = this.getLogger();
        if (!this.getNodeEngine().getLocalMember().getVersion().asVersion().equals(this.coordinatorVersion)) {
            throw new JetException("Mismatch between coordinator and participant version");
        }
        JetServiceBackend service = this.getJetServiceBackend();
        Address caller = this.getCallerAddress();
        logger.fine("Initializing execution plan for %s from %s", Util.jobIdAndExecutionId(this.jobId(), this.executionId), caller);
        ExecutionPlan plan = this.deserializePlan(this.serializedPlan);
        if (this.isLightJob) {
            return service.getJobExecutionService().runLightJob(this.jobId(), this.executionId, this.getCallerAddress(), this.coordinatorMemberListVersion, this.participants, plan);
        }
        return service.getJobExecutionService().initExecution(this.jobId(), this.executionId, this.getCallerAddress(), this.coordinatorMemberListVersion, this.participants, plan);
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeBoolean(this.isLightJob);
        out.writeInt(this.coordinatorMemberListVersion);
        out.writeObject(this.coordinatorVersion);
        out.writeInt(this.participants.size());
        for (MemberInfo participant : this.participants) {
            out.writeObject(participant);
        }
        IOUtil.writeData(out, this.serializedPlan);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.isLightJob = in.readBoolean();
        this.coordinatorMemberListVersion = in.readInt();
        this.coordinatorVersion = (Version)in.readObject();
        int count = in.readInt();
        this.participants = new HashSet<MemberInfo>();
        for (int i2 = 0; i2 < count; ++i2) {
            this.participants.add((MemberInfo)in.readObject());
        }
        this.serializedPlan = IOUtil.readData(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionPlan deserializePlan(Data planBlob) {
        if (this.isLightJob) {
            return (ExecutionPlan)this.getNodeEngine().getSerializationService().toObject(planBlob);
        }
        JetServiceBackend service = this.getJetServiceBackend();
        JobConfig jobConfig = service.getJobConfig(this.jobId(), this.isLightJob);
        JobClassLoaderService jobClassloaderService = service.getJobClassLoaderService();
        ClassLoader cl = jobClassloaderService.getOrCreateClassLoader(jobConfig, this.jobId(), JobClassLoaderService.JobPhase.EXECUTION);
        try {
            jobClassloaderService.prepareProcessorClassLoaders(this.jobId());
            ExecutionPlan executionPlan = (ExecutionPlan)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.getNodeEngine().getSerializationService(), cl, planBlob);
            return executionPlan;
        }
        finally {
            jobClassloaderService.clearProcessorClassLoaders();
        }
    }
}

