/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class EntryListIntegerUUIDCodec {
    private static final int ENTRY_SIZE_IN_BYTES = 21;

    private EntryListIntegerUUIDCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Map.Entry<Integer, UUID>> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 21]);
        Iterator<Map.Entry<Integer, UUID>> iterator = collection.iterator();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            Map.Entry<Integer, UUID> entry = iterator.next();
            FixedSizeTypesCodec.encodeInt(frame.content, i2 * 21, entry.getKey());
            FixedSizeTypesCodec.encodeUUID(frame.content, i2 * 21 + 4, entry.getValue());
        }
        clientMessage.add(frame);
    }

    public static List<Map.Entry<Integer, UUID>> decode(ClientMessage.ForwardFrameIterator iterator) {
        ClientMessage.Frame frame = iterator.next();
        int itemCount = frame.content.length / 21;
        ArrayList<Map.Entry<Integer, UUID>> result = new ArrayList<Map.Entry<Integer, UUID>>(itemCount);
        for (int i2 = 0; i2 < itemCount; ++i2) {
            int key = FixedSizeTypesCodec.decodeInt(frame.content, i2 * 21);
            UUID value = FixedSizeTypesCodec.decodeUUID(frame.content, i2 * 21 + 4);
            result.add(new AbstractMap.SimpleEntry<Integer, UUID>(key, value));
        }
        return result;
    }
}

