/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.pop3;

import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.Config;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.MessageVortexRepository;
import net.messagevortex.transport.Transport;
import net.messagevortex.transport.TransportReceiver;

public class TestPop3Handler
implements Transport {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final GreenMail server;
    private final TransportReceiver blender;
    private final GreenMailUser outUser;
    private final String section;

    public TestPop3Handler(String section) throws IOException {
        this.section = section;
        Config cfg = Config.getDefault();
        this.blender = MessageVortexRepository.getBlender("", cfg.getStringValue(section, "blender"));
        if (this.blender == null) {
            throw new IOException("unable to fetch appropriate blender");
        }
        this.server = new GreenMail(new ServerSetup[]{new ServerSetup(cfg.getNumericValue(section, "pop3_outgoing_port"), cfg.getStringValue(section, "pop3_outgoing_address"), "pop3")});
        this.outUser = this.server.setUser(cfg.getStringValue(section, "pop3_outgoing_user"), cfg.getStringValue(section, "pop3_outgoing_password"));
        this.startDaemon();
    }

    @Override
    public void sendMessage(String address, InputStream os) throws IOException {
        try {
            MimeMessage msg = new MimeMessage(null, os);
            this.outUser.deliver(msg);
            LOGGER.log(Level.INFO, "got message ready to fetch in transport layer [POP3] named \"" + this.section + "\"");
        }
        catch (MessagingException me) {
            throw new IOException("exception while creating MimeMessage", me);
        }
    }

    @Override
    public final void startDaemon() {
        this.server.start();
    }

    @Override
    public void stopDaemon() {
        this.server.stop();
    }

    @Override
    public void shutdownDaemon() {
        this.stopDaemon();
    }
}

