/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1.encryption;

import java.util.ArrayList;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.Padding;
import org.bouncycastle.asn1.ASN1Enumerated;

public enum Mode {
    ECB(10000, "ECB", false, new String[]{"ECIES", "RSA", "CAMELLIA128", "CAMELLIA192", "CAMELLIA256", "Twofish128", "Twofish192", "Twofish256"}, new Padding[]{Padding.PKCS7}),
    CBC(10001, "CBC", true, new String[]{"aes128", "aes192", "aes256", "CAMELLIA128", "CAMELLIA192", "CAMELLIA256", "Twofish128", "Twofish192", "Twofish256"}, new Padding[]{Padding.PKCS7}),
    EAX(10002, "EAX", true, new String[]{"CAMELLIA128", "CAMELLIA192", "CAMELLIA256", "Twofish128", "Twofish192", "Twofish256"}, new Padding[]{Padding.PKCS7}),
    CTR(10003, "CTR", true, new String[]{"aes128", "aes192", "aes256", "CAMELLIA128", "CAMELLIA192", "CAMELLIA256", "Twofish128", "Twofish192", "Twofish256"}, new Padding[]{Padding.PKCS7}),
    CCM(10004, "CCM", true, new String[]{"aes128", "aes192", "aes256", "CAMELLIA128", "CAMELLIA192", "CAMELLIA256", "Twofish128", "Twofish192", "Twofish256"}, new Padding[]{Padding.PKCS7}),
    GCM(10005, "GCM", true, new String[]{"aes128", "aes192", "AES256", "CAMELLIA128", "CAMELLIA192", "CAMELLIA256", "Twofish128", "Twofish192", "Twofish256"}, new Padding[]{Padding.PKCS7}),
    OCB(10006, "OCB", true, new String[]{"aes128", "aes192", "AES256", "CAMELLIA128", "CAMELLIA192", "CAMELLIA256", "Twofish128", "Twofish192", "Twofish256"}, new Padding[]{Padding.PKCS7}),
    OFB(10007, "OFB", true, new String[]{"CAMELLIA128", "CAMELLIA192", "CAMELLIA256", "Twofish128", "Twofish192", "Twofish256"}, new Padding[]{Padding.PKCS7}),
    NONE(10100, "NONE", false, new String[]{"ECIES", "RSA"}, new Padding[]{Padding.PKCS7});

    final int id;
    final String txt;
    final boolean requiresInitVector;
    final String[] alg;
    final Padding[] pad;
    final ASN1Enumerated asn;

    private Mode(int id, String txt, boolean iv, String[] alg, Padding[] pad) {
        this.id = id;
        this.txt = txt;
        this.requiresInitVector = iv;
        this.alg = alg;
        this.pad = pad;
        this.asn = new ASN1Enumerated(id);
    }

    public boolean getRequiresInitVector() {
        return this.requiresInitVector;
    }

    public static Mode getById(int id) {
        for (Mode e : Mode.values()) {
            if (e.id != id) continue;
            return e;
        }
        return null;
    }

    public static Mode getByString(String name) {
        for (Mode e : Mode.values()) {
            if (!e.txt.equals(name)) continue;
            return e;
        }
        return null;
    }

    public static Mode getDefault(AlgorithmType type) {
        switch (type) {
            case ASYMMETRIC: {
                return ECB;
            }
            case SYMMETRIC: {
                return CBC;
            }
        }
        throw new IllegalArgumentException("Type " + String.valueOf(type) + " is not suitable for mode.");
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.txt;
    }

    public Padding[] getPaddings() {
        return (Padding[])this.pad.clone();
    }

    public static Mode[] getModes(Algorithm alg) {
        ArrayList<Mode> l = new ArrayList<Mode>();
        for (Mode m : Mode.values()) {
            for (String a : m.alg) {
                if (alg != Algorithm.getByString(a)) continue;
                l.add(m);
            }
        }
        return l.toArray(new Mode[0]);
    }

    public ASN1Enumerated toAsn1() {
        return this.asn;
    }
}

