/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1.encryption;

import java.util.ArrayList;
import net.messagevortex.asn1.encryption.SecurityLevel;

public enum EllipticCurveType {
    SECP384R1(2500, "secp384r1", 384, SecurityLevel.MEDIUM),
    SECT409K1(2501, "sect409k1", 409, SecurityLevel.HIGH),
    SECP521R1(2502, "secp521r1", 521, SecurityLevel.QUANTUM);

    private static final EllipticCurveType def;
    private final int id;
    private final String txt;
    private final SecurityLevel secLevel;
    private final int keySize;

    private EllipticCurveType(int id, String txt, int keySize, SecurityLevel level) {
        this.id = id;
        this.txt = txt;
        this.secLevel = level;
        this.keySize = keySize;
    }

    public static EllipticCurveType getById(int id) {
        for (EllipticCurveType e : EllipticCurveType.values()) {
            if (e.id != id) continue;
            return e;
        }
        return null;
    }

    public static EllipticCurveType[] getByKeySize(int ks) {
        ArrayList<EllipticCurveType> l = new ArrayList<EllipticCurveType>();
        for (EllipticCurveType e : EllipticCurveType.values()) {
            if (e.getKeySize() != ks) continue;
            l.add(e);
        }
        return l.toArray(new EllipticCurveType[0]);
    }

    public static EllipticCurveType getByString(String s) {
        for (EllipticCurveType e : EllipticCurveType.values()) {
            if (!e.toString().equals(s)) continue;
            return e;
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.txt;
    }

    public SecurityLevel getSecurityLevel() {
        return this.secLevel;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public static EllipticCurveType getDefault() {
        return def;
    }

    static {
        def = SECP521R1;
    }
}

