/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.SymmetricKey;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class PrefixBlock
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 100000000014L;
    byte[] encrypted = null;
    AsymmetricKey decryptionKey = null;
    SymmetricKey key = null;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());

    public PrefixBlock() throws IOException {
        this(null);
    }

    public PrefixBlock(SymmetricKey sk) throws IOException {
        this.key = sk == null ? new SymmetricKey() : sk;
    }

    public PrefixBlock(ASN1Primitive to, AsymmetricKey ak) throws IOException {
        this(PrefixBlock.toDer((ASN1Object)to), ak);
    }

    public PrefixBlock(byte[] to, AsymmetricKey ak) throws IOException {
        AsymmetricKey decrypt;
        if (ak != null) {
            this.setDecryptionKey(ak);
        }
        if ((decrypt = this.getDecryptionKey()) != null && decrypt.hasPrivateKey()) {
            this.parse((ASN1Encodable)ASN1Sequence.getInstance((Object)decrypt.decrypt(to)));
        } else {
            try {
                this.parse((ASN1Encodable)ASN1Sequence.getInstance((Object)to));
            }
            catch (IOException | RuntimeException ioe) {
                LOGGER.log(Level.WARNING, "Parsing of prefix block failed", ioe);
                this.setDecryptionKey(null);
                this.key = null;
                this.encrypted = Arrays.copyOf(to, to.length);
            }
        }
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        this.encrypted = null;
        LOGGER.log(Level.FINER, "Executing parse()");
        ASN1Sequence s1 = ASN1Sequence.getInstance((Object)to);
        this.key = new SymmetricKey(PrefixBlock.toDer((ASN1Object)s1.getObjectAt(0).toASN1Primitive()), null);
    }

    public final AsymmetricKey setDecryptionKey(AsymmetricKey dk) throws IOException {
        AsymmetricKey old = this.getDecryptionKey();
        this.decryptionKey = dk;
        if (this.isEncrypted()) {
            this.parse(dk.decrypt(this.encrypted));
        }
        return old;
    }

    public final AsymmetricKey getDecryptionKey() {
        return this.decryptionKey;
    }

    public SymmetricKey setKey(SymmetricKey dk) {
        if (dk == null) {
            throw new NullPointerException("symmetric key may not be null");
        }
        SymmetricKey old = this.getKey();
        this.key = dk;
        this.encrypted = null;
        return old;
    }

    public SymmetricKey getKey() {
        return this.key;
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        if (this.getKey() == null && this.isEncrypted()) {
            throw new IOException("only encrypted form may be dumped without providing a valid decryption key");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        ASN1Object o = this.getKey().toAsn1Object(dumpType);
        if (o == null) {
            throw new IOException("returned symmetric object may not be null");
        }
        v.add((ASN1Encodable)o);
        LOGGER.log(Level.FINER, "done toAsn1Object() of PrefixBlock");
        return new DERSequence(v);
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (DumpType.ALL == dumpType || DumpType.PUBLIC_ONLY == dumpType) {
            sb.append("encrypted ").append(PrefixBlock.toHex(this.toEncBytes()));
        } else {
            sb.append("plain  {").append("\r\n");
            sb.append(prefix).append("  key ").append(this.key.dumpValueNotation(prefix + "  ", dumpType)).append("\r\n");
            sb.append(prefix).append('}');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        PrefixBlock p = (PrefixBlock)o;
        if (p.getKey() == null && this.getKey() != null || p.getKey() != null && this.getKey() == null) {
            return false;
        }
        return p.getKey() == null || p.getKey().equals(this.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean isEncrypted() {
        return this.encrypted != null;
    }

    public byte[] toEncBytes() throws IOException {
        if (this.decryptionKey != null && this.encrypted == null && this.decryptionKey.hasPrivateKey()) {
            byte[] b;
            int maxSize = this.decryptionKey.getPadding().getMaxSize(this.decryptionKey.getBlockSize());
            if (maxSize < (b = this.toBytes(DumpType.PUBLIC_ONLY)).length) {
                throw new IOException("unable to encrypt current prefix block (prefixSize: " + b.length + "; maxSize: " + maxSize + ")");
            }
            return this.decryptionKey.encrypt(b);
        }
        if (this.encrypted == null) {
            return null;
        }
        return (byte[])this.encrypted.clone();
    }
}

