/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.UsagePeriod;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.asn1.encryption.SecurityLevel;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.util.encoders.Base64;

public class IdentityStoreBlock
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 10000000024L;
    public static final String UNENCODABLE = "<UNENCODABLE>";
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private UsagePeriod valid = null;
    private int messageQuota = 0;
    private int transferQuota = 0;
    private AsymmetricKey identityKey = null;
    private String nodeAddress = null;
    private AsymmetricKey nodeKey = null;
    private IdentityType idType = null;

    public IdentityStoreBlock() {
    }

    public IdentityStoreBlock(ASN1Encodable ae) throws IOException {
        this.parse(ae);
    }

    public IdentityStoreBlock(String url) throws IOException {
        if (url == null || !url.toLowerCase().startsWith("vortexsmtp://")) {
            throw new IOException("unable to parse " + url);
        }
        LOGGER.log(Level.INFO, "Creating identity from URL " + url);
        String[] s = url.substring(13).split("\\.\\.");
        String[] s2 = s[2].split("@");
        this.identityKey = new AsymmetricKey(Base64.decode((String)s[1]));
        this.nodeAddress = "smtp:" + s[0] + "@" + s2[0];
        this.valid = new UsagePeriod();
    }

    public int hashCode() {
        try {
            return this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED).hashCode();
        }
        catch (IOException e) {
            return "".hashCode();
        }
    }

    public static IdentityStoreBlock getIdentityStoreBlockDemo(IdentityType it, String id, boolean complete) throws IOException {
        IdentityStoreBlock ret = new IdentityStoreBlock();
        ret.setValid(new UsagePeriod(2592000L));
        ret.setTransferQuota(ExtendedSecureRandom.nextInt(0x40000000));
        ret.setMessageQuota(ExtendedSecureRandom.nextInt(0x100000));
        ret.idType = it;
        if (id == null) {
            byte[] b = new byte[ExtendedSecureRandom.nextInt(20) + 3];
            ExtendedSecureRandom.nextBytes(b);
            id = IdentityStoreBlock.toHex(b) + "@localhost";
        }
        switch (it) {
            case OWNED_IDENTITY: {
                try {
                    ret.setIdentityKey(new AsymmetricKey(Algorithm.RSA.getParameters(SecurityLevel.LOW)));
                    ret.setNodeAddress("smtp:" + (String)id);
                    ret.setNodeKey(null);
                    break;
                }
                catch (Exception e) {
                    throw new IOException("Exception while generating owned identity", e);
                }
            }
            case NODE_IDENTITY: {
                try {
                    ret.setIdentityKey(null);
                    ret.setNodeAddress("smtp:" + (String)id);
                    AsymmetricKey ak = new AsymmetricKey();
                    if (!complete) {
                        ak.setPrivateKey(null);
                    }
                    ret.setNodeKey(ak);
                    break;
                }
                catch (Exception e) {
                    throw new IOException("Exception while generating node identity", e);
                }
            }
            case RECIPIENT_IDENTITY: {
                try {
                    AsymmetricKey ak = new AsymmetricKey(Algorithm.EC.getParameters(SecurityLevel.LOW));
                    if (!complete) {
                        ak.setPrivateKey(null);
                    }
                    ret.setIdentityKey(ak);
                    ret.setNodeAddress("smtp:" + (String)id);
                    ak = new AsymmetricKey();
                    if (!complete) {
                        ak.setPrivateKey(null);
                    }
                    ret.setNodeKey(ak);
                    break;
                }
                catch (Exception e) {
                    throw new IOException("Exception while generating recipient identity", e);
                }
            }
            default: {
                return null;
            }
        }
        return ret;
    }

    public AsymmetricKey setIdentityKey(AsymmetricKey k) {
        AsymmetricKey old = this.identityKey;
        this.identityKey = k;
        return old;
    }

    public AsymmetricKey getIdentityKey() {
        return this.identityKey;
    }

    public UsagePeriod setValid(UsagePeriod np) {
        UsagePeriod old = this.valid;
        this.valid = np;
        return old;
    }

    public UsagePeriod getValid() {
        return this.valid;
    }

    public int setMessageQuota(int nq) {
        int old = this.messageQuota;
        this.messageQuota = nq;
        return old;
    }

    public int getMessageQuota() {
        return this.messageQuota;
    }

    public int setTransferQuota(int tq) {
        int old = this.transferQuota;
        this.transferQuota = tq;
        return old;
    }

    public int getTransferQuota() {
        return this.transferQuota;
    }

    public String setNodeAddress(String na) {
        String old = this.nodeAddress;
        this.nodeAddress = na;
        return old;
    }

    public String getNodeAddress() {
        return this.nodeAddress;
    }

    public AsymmetricKey setNodeKey(AsymmetricKey k) {
        AsymmetricKey old = this.nodeKey;
        this.nodeKey = k;
        return old;
    }

    public AsymmetricKey getNodeKey() {
        return this.nodeKey;
    }

    @Override
    protected final void parse(ASN1Encodable p) throws IOException {
        LOGGER.log(Level.FINER, "Executing parse()");
        ASN1Sequence s1 = ASN1Sequence.getInstance((Object)p);
        int i = 0;
        this.valid = new UsagePeriod(s1.getObjectAt(i++));
        this.messageQuota = ASN1Integer.getInstance((Object)s1.getObjectAt(i++)).getValue().intValue();
        this.transferQuota = ASN1Integer.getInstance((Object)s1.getObjectAt(i++)).getValue().intValue();
        LOGGER.log(Level.FINER, "Finished parse()");
        while (i < s1.size()) {
            ASN1TaggedObject to = ASN1TaggedObject.getInstance((Object)s1.getObjectAt(i));
            switch (to.getTagNo()) {
                case 1001: {
                    this.identityKey = new AsymmetricKey(IdentityStoreBlock.toDer(to.getBaseObject()));
                    break;
                }
                case 1002: {
                    this.nodeAddress = ((ASN1String)to.getBaseObject()).getString();
                    break;
                }
                case 1003: {
                    this.nodeKey = new AsymmetricKey(IdentityStoreBlock.toDer(to.getBaseObject()));
                    break;
                }
                default: {
                    throw new IOException("unknown tag encountered");
                }
            }
            ++i;
        }
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        LOGGER.log(Level.FINER, "Executing toAsn1Object()");
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.valid.toAsn1Object(dumpType));
        v.add((ASN1Encodable)new ASN1Integer((long)this.messageQuota));
        v.add((ASN1Encodable)new ASN1Integer((long)this.transferQuota));
        if (this.identityKey != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, 1001, (ASN1Encodable)this.identityKey.toAsn1Object(dumpType)));
        }
        if (this.nodeAddress != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, 1002, (ASN1Encodable)new DERUTF8String(this.nodeAddress)));
        }
        if (this.nodeKey != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, 1003, (ASN1Encodable)this.nodeKey.toAsn1Object(dumpType)));
        }
        DERSequence seq = new DERSequence(v);
        LOGGER.log(Level.FINER, "done toAsn1Object()");
        return seq;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        String url = this.getUrl();
        sb.append(prefix).append("  -- ").append(url).append("\r\n");
        sb.append(prefix).append("  -- size: ").append(url.length()).append("\r\n");
        sb.append(prefix).append("  -- encoded size: ").append(this.toAsn1Object(DumpType.ALL_UNENCRYPTED).getEncoded().length).append("\r\n");
        sb.append(prefix).append("  valid ").append(this.valid.dumpValueNotation(prefix + "  ", dumpType)).append(',').append("\r\n");
        sb.append(prefix).append("  messageQuota ").append(this.messageQuota).append(',').append("\r\n");
        sb.append(prefix).append("  transferQuota ").append(this.transferQuota);
        if (this.identityKey != null) {
            sb.append(',').append("\r\n");
            sb.append(prefix).append("  identity ").append(this.identityKey.dumpValueNotation(prefix + "  ", dumpType));
        }
        if (this.nodeAddress != null) {
            sb.append(',').append("\r\n");
            sb.append(prefix).append("  nodeAddress \"").append(this.nodeAddress).append('\"');
        }
        if (this.nodeKey != null) {
            sb.append(',').append("\r\n");
            sb.append(prefix).append("  nodeKey ").append(this.nodeKey.dumpValueNotation(prefix + "  ", dumpType));
        }
        sb.append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    public String getUrl() throws IOException {
        if (this.nodeAddress.startsWith("smtp:")) {
            String[] addr = this.nodeAddress.substring(5).split("@");
            if (this.identityKey == null) {
                LOGGER.log(Level.WARNING, "unable to encode identity key of " + this.nodeAddress + " (key is null)");
                return UNENCODABLE;
            }
            ASN1Object e = this.identityKey.toAsn1Object(DumpType.PUBLIC_ONLY);
            String keySpec = IdentityStoreBlock.toBase64(e.getEncoded());
            return "vortexsmtp://" + addr[0] + ".." + keySpec + ".." + addr[1] + "@localhost";
        }
        return UNENCODABLE;
    }

    public IdentityType getType() {
        if (this.idType != null) {
            return this.idType;
        }
        if (this.nodeKey == null && this.identityKey.privateKey != null) {
            return IdentityType.OWNED_IDENTITY;
        }
        return this.identityKey == null ? IdentityType.NODE_IDENTITY : IdentityType.RECIPIENT_IDENTITY;
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t.getClass() != this.getClass()) {
            return false;
        }
        IdentityStoreBlock isb = (IdentityStoreBlock)t;
        if (!this.valid.equals(isb.valid)) {
            return false;
        }
        if (this.messageQuota != isb.messageQuota) {
            return false;
        }
        if (this.transferQuota != isb.transferQuota) {
            return false;
        }
        if (this.identityKey == null && isb.identityKey != null || this.identityKey != null && !this.identityKey.equals(isb.identityKey)) {
            return false;
        }
        if (this.nodeAddress != null && !this.nodeAddress.equals(isb.nodeAddress) || this.nodeAddress == null && isb.nodeAddress != null) {
            return false;
        }
        return this.nodeKey == null && isb.nodeKey == null || this.nodeKey != null && this.nodeKey.equals(isb.nodeKey);
    }

    public static enum IdentityType {
        OWNED_IDENTITY,
        NODE_IDENTITY,
        RECIPIENT_IDENTITY;

    }
}

