/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.messagevortex.RunningDaemon;
import net.messagevortex.accounting.Accountant;
import net.messagevortex.asn1.IdentityBlock;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.blender.Blender;
import net.messagevortex.router.Router;
import net.messagevortex.router.operation.InternalPayloadSpace;
import net.messagevortex.router.operation.InternalPayloadSpaceStore;
import net.messagevortex.transport.Transport;

public class MessageVortexRepository {
    private static final Map<String, Store> store = new ConcurrentHashMap<String, Store>();

    public static void setTransport(String uid, String id, Transport a) {
        Store rstore = store.get(uid);
        if (rstore == null) {
            rstore = new Store();
            store.put(uid, rstore);
        }
        rstore.transport.put(id.toLowerCase(), a);
    }

    public static Accountant getAccountant(String uid, String id) {
        Store rstore = store.get(uid);
        if (rstore == null || id == null) {
            return null;
        }
        return rstore.accountant.get(id.toLowerCase());
    }

    public static void setAccountant(String uid, String id, Accountant a) {
        Store rstore = store.get(uid);
        if (rstore == null) {
            rstore = new Store();
            store.put(uid, rstore);
        }
        rstore.accountant.put(id.toLowerCase(), a);
    }

    public static Blender getBlender(String uid, String id) {
        Store rstore = store.get(uid);
        if (rstore == null || id == null) {
            return null;
        }
        return rstore.blender.get(id.toLowerCase());
    }

    public static void setBlender(String uid, String id, Blender a) {
        Store rstore = store.get(uid);
        if (rstore == null) {
            rstore = new Store();
            store.put(uid, rstore);
        }
        rstore.blender.put(id.toLowerCase(), a);
    }

    public static Router getRouter(String uid, String id) {
        Store rstore = store.get(uid);
        if (rstore == null || id == null) {
            return null;
        }
        return rstore.router.get(id.toLowerCase());
    }

    public static void setRouter(String uid, String id, Router a) {
        Store rstore = store.get(uid);
        if (rstore == null) {
            rstore = new Store();
            store.put(uid, rstore);
        }
        rstore.router.put(id.toLowerCase(), a);
    }

    public static IdentityStore getIdentityStore(String uid, String id) {
        Store rstore = store.get(uid);
        if (rstore == null || id == null) {
            return null;
        }
        return rstore.identityStore.get(id.toLowerCase());
    }

    public static void setIdentityStore(String uid, String id, IdentityStore is) {
        Store rstore = store.get(uid);
        if (rstore == null) {
            rstore = new Store();
            store.put(uid, rstore);
        }
        rstore.identityStore.put(id.toLowerCase(), is);
    }

    public static InternalPayloadSpace getSimulatedSpace(String uid, IdentityBlock ib) {
        Store rstore = store.get(uid);
        if (rstore == null) {
            return null;
        }
        return rstore.simStores.getInternalPayload(ib);
    }

    public static InternalPayloadSpace getOwnSpace(String uid, IdentityBlock ib) {
        Store rstore = store.get(uid);
        if (rstore == null) {
            return null;
        }
        return rstore.ownStores.getInternalPayload(ib);
    }

    public static void clear(String uid) {
        store.remove(uid);
    }

    public static Map<String, RunningDaemon> getRunningDaemons(String uid) {
        Store rstore = store.get(uid);
        if (rstore == null) {
            return null;
        }
        HashMap<String, RunningDaemon> ret = new HashMap<String, RunningDaemon>();
        ret.putAll(rstore.transport);
        ret.putAll(rstore.blender);
        ret.putAll(rstore.router);
        ret.putAll(rstore.accountant);
        return ret;
    }

    private static class Store {
        public final Map<String, Transport> transport = new ConcurrentHashMap<String, Transport>();
        public final Map<String, Blender> blender = new ConcurrentHashMap<String, Blender>();
        public final Map<String, Router> router = new ConcurrentHashMap<String, Router>();
        public final Map<String, Accountant> accountant = new ConcurrentHashMap<String, Accountant>();
        public final Map<String, IdentityStore> identityStore = new ConcurrentHashMap<String, IdentityStore>();
        public final InternalPayloadSpaceStore ownStores = new InternalPayloadSpaceStore();
        public final InternalPayloadSpaceStore simStores = new InternalPayloadSpaceStore();

        private Store() {
        }
    }
}

