/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.classes.JarClasses;
import org.apache.maven.shared.jar.classes.JarClassesAnalysis;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;

@Singleton
@Named(value="jarClasses")
public class JarClassesExposer
implements JarIdentificationExposer {
    private final JarClassesAnalysis analyzer;

    @Inject
    public JarClassesExposer(JarClassesAnalysis analyzer) {
        this.analyzer = Objects.requireNonNull(analyzer);
    }

    @Override
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        JarClasses jarclasses = this.analyzer.analyze(jarAnalyzer);
        for (String packagename : jarclasses.getPackages()) {
            identification.addGroupId(packagename);
        }
    }
}

