/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationexecutor.impl;

import com.hazelcast.internal.tpcengine.Eventloop;
import com.hazelcast.internal.tpcengine.Scheduler;
import com.hazelcast.spi.impl.operationexecutor.impl.OperationQueue;
import com.hazelcast.spi.impl.operationexecutor.impl.TpcPartitionOperationThread;
import java.util.concurrent.TimeUnit;

public class TpcOperationScheduler
implements Scheduler {
    private static final int TIME_SLICE_US_DEFAULT = 500;
    private static final String TIME_SLICE_US_NAME = "hazelcast.internal.tpc.timeSliceUs";
    private TpcPartitionOperationThread operationThread;
    private OperationQueue queue;
    private final long timeSliceNs;

    public TpcOperationScheduler() {
        long timeSliceUs = Integer.getInteger(TIME_SLICE_US_NAME, 500).intValue();
        this.timeSliceNs = TimeUnit.MICROSECONDS.toNanos(timeSliceUs);
    }

    @Override
    public void init(Eventloop eventloop) {
        this.operationThread = (TpcPartitionOperationThread)Thread.currentThread();
        this.queue = this.operationThread.queue;
    }

    @Override
    public boolean tick() {
        TpcPartitionOperationThread operationThread0 = this.operationThread;
        OperationQueue queue0 = this.queue;
        long timeSliceNs0 = this.timeSliceNs;
        long startNs = System.nanoTime();
        do {
            if (operationThread0.isShutdown()) {
                return false;
            }
            Object task = queue0.poll();
            if (task == null) {
                return false;
            }
            operationThread0.process(task);
        } while (System.nanoTime() - startNs < timeSliceNs0);
        return !queue0.isEmpty();
    }

    @Override
    public void schedule(Object task) {
        throw new UnsupportedOperationException();
    }
}

