/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import net.messagevortex.asn1.AddRedundancyOperation;
import net.messagevortex.asn1.DecryptPayloadOperation;
import net.messagevortex.asn1.EncryptPayloadOperation;
import net.messagevortex.asn1.MapBlockOperation;
import net.messagevortex.asn1.MergePayloadOperation;
import net.messagevortex.asn1.Operation;
import net.messagevortex.asn1.RemoveRedundancyOperation;
import net.messagevortex.asn1.SplitPayloadOperation;

enum OperationType {
    SPLIT_PAYLOAD(150, new SplitPayloadOperation()),
    MERGE_PAYLOAD(160, new MergePayloadOperation()),
    ENCRYPT_PAYLOAD(300, new EncryptPayloadOperation()),
    DECRYPT_PAYLOAD(310, new DecryptPayloadOperation()),
    ADD_REDUNDANCY(400, new AddRedundancyOperation()),
    REMOVE_REDUNDANCY(410, new RemoveRedundancyOperation()),
    MAP(1001, new MapBlockOperation());

    int id;
    Operation operation;

    private OperationType(int id, Operation operation) {
        this.id = id;
        this.operation = operation;
    }

    int getId() {
        return this.id;
    }

    Operation getFactory() {
        return this.operation;
    }

    public static OperationType getById(int id) {
        for (OperationType e : OperationType.values()) {
            if (e.id != id) continue;
            return e;
        }
        return null;
    }
}

