/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex;

import java.security.SecureRandom;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;

public final class ExtendedSecureRandom {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static final SecureRandom sr = new SecureRandom();

    public static int nextInt(int bound) {
        return sr.nextInt(bound);
    }

    public static int nextInt(int low, int up) {
        if (low >= up) {
            throw new IllegalArgumentException("lower bound is not smaller than upper bound");
        }
        return low + sr.nextInt(up - low);
    }

    public static void nextBytes(byte[] array) {
        sr.nextBytes(array);
    }

    public static byte[] generateSeed(int i) {
        return sr.generateSeed(i);
    }

    public static double nextDouble() {
        return sr.nextDouble();
    }

    public static SecureRandom getSecureRandom() {
        return sr;
    }

    public static double nextGauss() {
        double result = -1.0;
        while (result < 0.0 || result > 1.0) {
            result = (sr.nextGaussian() + Math.E) / 2.0 / Math.E;
        }
        return result;
    }

    public static double nextRandomTime(long start, long peak, long end) {
        if (peak <= start || end <= peak) {
            throw new NullPointerException("random time must offer a valid window [start(" + start + ")<peak(" + peak + ")<end(" + end + ")]");
        }
        double ret = -1.0;
        while (ret < (double)start || ret > (double)end) {
            ret = sr.nextGaussian();
            double d = sr.nextDouble();
            if (d < (double)(peak - start) / (double)(end - start)) {
                ret = (double)peak - Math.abs(ret) * (double)(peak - start) / 5.0;
                continue;
            }
            ret = (double)peak + Math.abs(ret) * (double)(end - peak) / 5.0;
        }
        return ret;
    }
}

